#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string>
#include <vector>
using namespace std;


typedef BOOL (__stdcall *docPrint_SetOptionsFunc)(const char *lpKeyName, const char *lpString);
typedef int  (__stdcall *docPrint_DocumentConverterFunc)(const char *lpDocFile,const char *lpOutputFile, const char *lpOptions);
typedef int  (__stdcall *docPrint_DocumentConverterExFunc)(const char * username, const char *password, 
				const char *lpDocFile,const char *lpOutputFile, const char *lpOptions);
typedef BOOL (__stdcall *docPrint_ChangePrinterSettingsFunc)(const char *ptrPrintName,DEVMODE *lpDevMode);;
typedef void (__stdcall *docPrint_RegisterFunc)(const char *lpOrderID, const char *lpCompanyName);

typedef long (__stdcall *ImageStampOpenFunc)(char *In,char *Out, int nPage);
typedef void (__stdcall *ImageStampCloseFunc)(long id);
typedef long (__stdcall *ImageStampAddTextFunc)( long id, int x, int y, char *m_text,long color,LOGFONT m_font,int style);
typedef long (__stdcall *ImageStampAddImageFunc)(long id,int x,int y, int width, int height,char *filename,BOOL bTransparent);
typedef long (__stdcall *ImageStampGetInfoFunc)(long id,LPBITMAPINFOHEADER lpbi);
typedef long (__stdcall *ImageStampCloseAndNotSaveFunc)(long id);
typedef long (__stdcall *ImageStampShowFunc)(long id,HDC hDC,RECT *rcDst, RECT *rcSrc);
typedef void (__stdcall *ImageStampAddLineFunc)(long id, int x0, int y0, int x1, int y1, int width,long color,int style);
typedef HDC  (__stdcall *ImageStampGetHDCFunc)(long id);
typedef long (__stdcall *ImageStampReleaseHDCFunc)(long id, HDC hDC);

typedef int (__stdcall *TIFFImageGetPageCountFunc)(char *inputTIFFFile);
typedef int (__stdcall *TIFFImageGetColorsFunc)(char *inputTIFFFile, int pageno);
typedef int (__stdcall *TIFFImageGetCompressionFunc)(char *inputTIFFFile, int pageno);
typedef int (__stdcall *TIFFImageSetOptionsFunc)(char *inputTIFFFile, int pageno, int colors, int compression);
typedef int (__stdcall *TIFFImageSetOptionsExFunc)(char *inputTIFFFile, char *outTIFFFile, int pageno, int colors, int compression, int nG3Options);
typedef int (__stdcall *TIFFImageExtractPageFunc)(const char *srcImage,int pageno,const char *szOutputFilename);
typedef int (__stdcall *TIFFImageGetPageSizeFunc)(char *inputTIFFFile, int pageno,long *out_w,long *out_h);
typedef int (__stdcall *TIFFImageGetPageDPIFunc)(char *inputTIFFFile, int pageno,long *dpix,long *dpiy);
typedef int (__stdcall *TIFFImageMergeFilesFunc)(char *lpszFileNameBuf, char *lpszTIFFile);

HMODULE							g_hVeryW=NULL;

docPrint_SetOptionsFunc				docPrint_SetOptions;
docPrint_DocumentConverterFunc		docPrint_DocumentConverter;
docPrint_DocumentConverterExFunc	docPrint_DocumentConverterEx;
docPrint_ChangePrinterSettingsFunc	docPrint_ChangePrinterSettings;
docPrint_RegisterFunc				docPrint_Register;

ImageStampOpenFunc				ImageStampOpen;
ImageStampCloseFunc				ImageStampClose;
ImageStampAddTextFunc			ImageStampAddText;
ImageStampAddImageFunc			ImageStampAddImage;
ImageStampGetInfoFunc			ImageStampGetInfo;
ImageStampCloseAndNotSaveFunc	ImageStampCloseAndNotSave;
ImageStampShowFunc				ImageStampShow;
ImageStampAddLineFunc			ImageStampAddLine;
ImageStampGetHDCFunc			ImageStampGetHDC;
ImageStampReleaseHDCFunc		ImageStampReleaseHDC;

TIFFImageGetPageCountFunc		TIFFImageGetPageCount;
TIFFImageGetColorsFunc			TIFFImageGetColors;
TIFFImageGetCompressionFunc		TIFFImageGetCompression;
TIFFImageSetOptionsFunc			TIFFImageSetOptions;
TIFFImageSetOptionsExFunc		TIFFImageSetOptionsEx;
TIFFImageExtractPageFunc		TIFFImageExtractPage;
TIFFImageGetPageSizeFunc		TIFFImageGetPageSize;
TIFFImageGetPageDPIFunc			TIFFImageGetPageDPI;
TIFFImageMergeFilesFunc			TIFFImageMergeFiles;

void GetModulePath(char *out_path,char *in_name)
{
	char *p;
	GetModuleFileName(NULL,out_path,256);
	p =strrchr(out_path,'\\');
	p[1]=0;
	strcat(out_path,in_name);
}
void FreeVeryWDll()
{
	if(g_hVeryW==NULL)
		return ;
	FreeLibrary(g_hVeryW);
	g_hVeryW=NULL;
}

BOOL LoadVeryWDll()
{
	char path[_MAX_PATH];
	GetModulePath(path,"doc2img.dll");
	g_hVeryW=LoadLibrary(path);
	if(g_hVeryW==NULL)
		goto Failer;

	docPrint_SetOptions = (docPrint_SetOptionsFunc)GetProcAddress(g_hVeryW,"docPrint_SetOptions");
	if(docPrint_SetOptions == NULL)
		goto Failer;
	docPrint_DocumentConverter = (docPrint_DocumentConverterFunc)GetProcAddress(g_hVeryW,"docPrint_DocumentConverter");
	if(docPrint_DocumentConverter == NULL)
		goto Failer;
	docPrint_DocumentConverterEx = (docPrint_DocumentConverterExFunc)GetProcAddress(g_hVeryW,"docPrint_DocumentConverterEx");
	if(docPrint_DocumentConverterEx == NULL)
		goto Failer;
	docPrint_ChangePrinterSettings = (docPrint_ChangePrinterSettingsFunc)GetProcAddress(g_hVeryW,"docPrint_ChangePrinterSettings");
	if(docPrint_ChangePrinterSettings == NULL)
		goto Failer;
	docPrint_Register = (docPrint_RegisterFunc)GetProcAddress(g_hVeryW,"docPrint_Register");
	if(docPrint_Register == NULL)
		goto Failer;

	ImageStampOpen = (ImageStampOpenFunc)GetProcAddress(g_hVeryW,"ImageStampOpen");
	if(ImageStampOpen == NULL)
		goto Failer;
	ImageStampClose = (ImageStampCloseFunc)GetProcAddress(g_hVeryW,"ImageStampClose");
	if(ImageStampClose == NULL)
		goto Failer;
	ImageStampAddText = (ImageStampAddTextFunc)GetProcAddress(g_hVeryW,"ImageStampAddText");
	if(ImageStampAddText == NULL)
		goto Failer;
	ImageStampAddImage = (ImageStampAddImageFunc)GetProcAddress(g_hVeryW,"ImageStampAddImage");
	if(ImageStampAddImage == NULL)
		goto Failer;
	ImageStampGetInfo = (ImageStampGetInfoFunc)GetProcAddress(g_hVeryW,"ImageStampGetInfo");
	if(ImageStampGetInfo == NULL)
		goto Failer;
	ImageStampCloseAndNotSave = (ImageStampCloseAndNotSaveFunc)GetProcAddress(g_hVeryW,"ImageStampCloseAndNotSave");
	if(ImageStampCloseAndNotSave == NULL)
		goto Failer;
	ImageStampShow = (ImageStampShowFunc)GetProcAddress(g_hVeryW,"ImageStampShow");
	if(ImageStampShow == NULL)
		goto Failer;
	ImageStampAddLine = (ImageStampAddLineFunc)GetProcAddress(g_hVeryW,"ImageStampAddLine");
	if(ImageStampAddLine == NULL)
		goto Failer;
	ImageStampGetHDC = (ImageStampGetHDCFunc)GetProcAddress(g_hVeryW,"ImageStampGetHDC");
	if(ImageStampGetHDC == NULL)
		goto Failer;
	ImageStampReleaseHDC = (ImageStampReleaseHDCFunc)GetProcAddress(g_hVeryW,"ImageStampReleaseHDC");
	if(ImageStampReleaseHDC == NULL)
		goto Failer;

	TIFFImageGetPageCount = (TIFFImageGetPageCountFunc)GetProcAddress(g_hVeryW,"TIFFImageGetPageCount");
	if(TIFFImageGetPageCount == NULL)
		goto Failer;
	TIFFImageGetColors = (TIFFImageGetColorsFunc)GetProcAddress(g_hVeryW,"TIFFImageGetColors");
	if(TIFFImageGetColors == NULL)
		goto Failer;
	TIFFImageGetCompression = (TIFFImageGetCompressionFunc)GetProcAddress(g_hVeryW,"TIFFImageGetCompression");
	if(TIFFImageGetCompression == NULL)
		goto Failer;
	TIFFImageSetOptions = (TIFFImageSetOptionsFunc)GetProcAddress(g_hVeryW,"TIFFImageSetOptions");
	if(TIFFImageSetOptions == NULL)
		goto Failer;
	TIFFImageSetOptionsEx = (TIFFImageSetOptionsExFunc)GetProcAddress(g_hVeryW,"TIFFImageSetOptionsEx");
	if(TIFFImageSetOptionsEx == NULL)
		goto Failer;
	TIFFImageExtractPage = (TIFFImageExtractPageFunc)GetProcAddress(g_hVeryW,"TIFFImageExtractPage");
	if(TIFFImageExtractPage == NULL)
		goto Failer;
	TIFFImageGetPageSize = (TIFFImageGetPageSizeFunc)GetProcAddress(g_hVeryW,"TIFFImageGetPageSize");
	if(TIFFImageGetPageSize == NULL)
		goto Failer;
	TIFFImageGetPageDPI = (TIFFImageGetPageDPIFunc)GetProcAddress(g_hVeryW,"TIFFImageGetPageDPI");
	if(TIFFImageGetPageDPI == NULL)
		goto Failer;
	TIFFImageMergeFiles = (TIFFImageMergeFilesFunc)GetProcAddress(g_hVeryW,"TIFFImageMergeFiles");
	if(TIFFImageMergeFiles == NULL)
		goto Failer;

	return TRUE;
Failer:
	FreeVeryWDll(); 
	return FALSE;

}
void ConvertDocumentToImage(LPCTSTR lpDocument, LPCTSTR lpImageFile)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	DEVMODE nDevMode;
	memset(&nDevMode,0,sizeof(nDevMode));
	nDevMode.dmFields = DM_PRINTQUALITY|DM_YRESOLUTION;
	nDevMode.dmPrintQuality = 100;
	nDevMode.dmYResolution = 100;
	nDevMode.dmColor = DMCOLOR_MONOCHROME;
	docPrint_ChangePrinterSettings("docPrint",&nDevMode);
		
	docPrint_Register("Your License Key","Your Company Name");
//	docPrint_SetOptions("m_bCreateFileForEachPage","1");
//	docPrint_SetOptions("m_strColorDepth","24");
//	docPrint_SetOptions("m_strResolution","200x200");
//	docPrint_SetOptions("m_bGrayscale","0");
//	//Use run length compression arithmetic for TIFF file
//	docPrint_SetOptions(".tif","-compress rle");
//	//docPrint_SetOptions(".tif","-compress lzw");
//	docPrint_SetOptions(".jpg","-quality 100");

	_splitpath(lpDocument,drive,dir,fname,ext);
	int iRet = 0;
	int iStartTick = GetTickCount();
	iRet = docPrint_DocumentConverter(lpDocument,lpImageFile, "-e -c 4 -E 2 -b 1 -r 200x200 -d -D");
//	if(!stricmp(ext,".pdf") || !stricmp(ext,".ps") || !stricmp(ext,".eps"))
//		iRet = docPrint_DocumentConverter(lpDocument,lpImageFile, NULL);
//	else
//		iRet = docPrint_DocumentConverter(lpDocument,lpImageFile, "-e -c 32773");
	int iEndTick = GetTickCount();

	printf("%s ==> %s : %s, time = %dms\n",lpDocument,lpImageFile,iRet==0?"Success":"Fail.",
		iEndTick-iStartTick);
}

DWORD VeryGetTempFileName(DWORD nBufferLength, LPTSTR lpBuffer, LPCTSTR lpPostfixString)
{
	char szTempPath[MAX_PATH];
	if(nBufferLength <= 0)
		return 0;
	GetTempPath(MAX_PATH, szTempPath);
	GetTempFileName(szTempPath,"pdf",0,lpBuffer);
	DeleteFile(lpBuffer);
	if(lpPostfixString)
		strcat(lpBuffer,lpPostfixString);
	return strlen(lpBuffer);
}
void StampTIFFFile(LPCTSTR lpInTIFF, LPCTSTR lpOutTIFF)
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	_splitpath(lpInTIFF,drive,dir,fname,ext);
	if(stricmp(ext, ".tif") != 0)
		return;
	_splitpath(lpOutTIFF,drive,dir,fname,ext);
	if(stricmp(ext, ".tif") != 0)
		return;

	LOGFONT font;
	memset(&font,0,sizeof(LOGFONT));

	vector<string> aryTIFFPages;
	int nPageCount = TIFFImageGetPageCount((char*)lpInTIFF);
	for(int page = 0; page < nPageCount; page++)
	{
		char szPageTmpFile[MAX_PATH];
		VeryGetTempFileName(MAX_PATH, szPageTmpFile, ".tif");
		//Stamp text&image into a TIFF file, get info from a TIFF file
		//Add a text stamp into TIFF file
		strcpy(font.lfFaceName,"Arial");
		font.lfHeight = 200;
		long id = ImageStampOpen((char*)lpInTIFF, szPageTmpFile, page);
		if(id < 0)
			return;
		ImageStampAddText(id,100,100,"This is a test!",RGB(0,0,0),font,0);
		
		font.lfEscapement = font.lfOrientation = 45*10;
		font.lfHeight = 150;
		ImageStampAddText(id,100,500,"This is a test!",RGB(0,0,0),font,1);

		//Add an image stamp into TIFF file
		char szInExampleName1[MAX_PATH];
		GetModulePath(szInExampleName1,"logo.jpg");
		ImageStampAddImage(id,0,0,100,100,szInExampleName1,TRUE);

		char szInExampleName2[MAX_PATH];
		GetModulePath(szInExampleName2,"test1.jpg");
		ImageStampAddImage(id,300,300,100,100,szInExampleName2,TRUE);

		ImageStampAddLine(id,100,100,800,800,5,RGB(255,0,0),PS_SOLID);

		ImageStampAddLine(id,100,500,800,800,10,RGB(0,0,0),PS_DASH);

		//Get Image Info from TIFF file
		BITMAPINFOHEADER infoHeader;
		ImageStampGetInfo(id,&infoHeader);

		HDC nTmpDC = ImageStampGetHDC(id);
		if(nTmpDC)
		{
			char *lpText = "ImageStampGetHDC() Test...";
			TextOut(nTmpDC,100,100,lpText,strlen(lpText));
			ImageStampReleaseHDC(id,nTmpDC);
			nTmpDC = NULL;
		}
		ImageStampClose(id);
		aryTIFFPages.push_back(szPageTmpFile);
	}

	int nBufferLen = aryTIFFPages.size()*MAX_PATH;
	char *lpszFileNameBuf = (char*)malloc(nBufferLen);
	char *lpszFileName = lpszFileNameBuf;
	memset(lpszFileNameBuf, 0, nBufferLen);
	for(int i = 0; i < aryTIFFPages.size(); i++)
	{
		strcpy(lpszFileName, aryTIFFPages[i].c_str());
		lpszFileName += strlen(lpszFileName)+1;
	}
	int nMergedPageCount = TIFFImageMergeFiles(lpszFileNameBuf, (char*)lpOutTIFF);
	free(lpszFileNameBuf);
	for(i = 0; i < aryTIFFPages.size(); i++)
		DeleteFile(aryTIFFPages[i].c_str());
}
int main(int argc, char* argv[])
{
	if(!LoadVeryWDll())
		return 0;
	if(argc != 3)
	{
		printf("Usage:\n");
		printf("\"%s\" \"C:\\input.doc\" \"C:\\input.tif\"\n",argv[0]);
		printf("\"%s\" \"C:\\input.doc\" \"C:\\input.jpg\"\n",argv[0]);
		printf("\"%s\" \"C:\\input.doc\" \"C:\\input.bmp\"\n",argv[0]);
		printf("\"%s\" \"C:\\input.doc\" \"C:\\input.emf\"\n",argv[0]);
		return 0;
	}
	const char *ptrDocFile = argv[1];
	const char *ptrOutputFile = argv[2];
	ConvertDocumentToImage(ptrDocFile, ptrOutputFile);
	StampTIFFFile(ptrOutputFile, ptrOutputFile);

	#define COMPRESSION_CCITTFAX3 3 
	#define GROUP3OPT_1DENCODING 0x0
	#define GROUP3OPT_2DENCODING 0x1 
	TIFFImageSetOptionsEx((char *)ptrOutputFile, "C:\\out-g3-2d.tif", 0, 0, COMPRESSION_CCITTFAX3, GROUP3OPT_2DENCODING);

	FreeVeryWDll();
	return 1;
}