// demo_converter_comDlg.cpp : implementation file
//

#include "stdafx.h"
#include "demo_converter_com.h"
#include "demo_converter_comDlg.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string>
#include <vector>
using namespace std;
#include <winspool.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const char* szPrinterName = "docPrint";
const char* szOutputFileName = "C:\\docPrint_output.tif";

char m_szIniFilename[MAX_PATH];
int  m_iWaitTime = 30;

__declspec(dllexport)
BOOL WINAPI docPrint_SetOptions(const char *lpKeyName, const char *lpString);
__declspec(dllexport)
int WINAPI docPrint_DocumentConverter(const char *lpDocFile,const char *lpOutputFile, const char *lpOptions);
__declspec(dllexport)
int WINAPI docPrint_DocumentConverterEx(const char * username, const char *password, 
				const char *lpDocFile,const char *lpOutputFile, const char *lpOptions);
__declspec(dllexport)
BOOL WINAPI docPrint_ChangePrinterSettings(const char *ptrPrintName,DEVMODE *lpDevMode);
__declspec(dllexport)
void WINAPI docPrint_Register(const char *lpKey1, const char *lpKey2);


BOOL GetConfigFilePath(char *m_szDesktopPrograms, int length)
{
	HKEY hCU;    
	DWORD dwType;    
	ULONG ulSize = MAX_PATH;
	HKEY hrkey = HKEY_CURRENT_USER;

	memset(m_szDesktopPrograms,0,length);
	hrkey = HKEY_LOCAL_MACHINE;
	if (RegOpenKeyEx(hrkey, 
		"SOFTWARE\\verypdf\\docprint", 
		0,KEY_QUERY_VALUE,&hCU) == ERROR_SUCCESS)
	{
		RegQueryValueEx(hCU,        
			//"Personal",
			"ConfigFile",
			NULL,        
			&dwType,
			(unsigned char *)m_szDesktopPrograms,        
			&ulSize);      
		RegCloseKey(hCU);    
	}
	else
		return FALSE;
	return TRUE;
}
void InitialIniFileName()
{
	GetConfigFilePath(m_szIniFilename,MAX_PATH);
}
void SetOutputFileName(const char *m_ptrOutputFile)
{
	if(m_ptrOutputFile == NULL || m_ptrOutputFile[0] == 0)
		return;

	InitialIniFileName();
	//Set the output filename to docPrint
	WritePrivateProfileString("AutoSave","IsAutoSave","1",m_szIniFilename);
	WritePrivateProfileString("AutoSave","OutputFile",m_ptrOutputFile,m_szIniFilename);

	WritePrivateProfileString("AutoSaveOptions","m_bCreateFileForEachPage","1",m_szIniFilename);
	WritePrivateProfileString("AutoSaveOptions","m_strColorDepth","24",m_szIniFilename);
	WritePrivateProfileString("AutoSaveOptions","m_strResolution","400x400",m_szIniFilename);
	WritePrivateProfileString("AutoSaveOptions","m_bGrayscale","0",m_szIniFilename);
	//Use run length compression arithmetic for TIFF file
	WritePrivateProfileString("AutoSaveOptions",".tif","-compress rle",m_szIniFilename);
	
}
string MyGetDefaultPrinter()
{
	string m_szDefaultPrinter;
	try{
		int bSet = 0;
		//ΪȱʡĴӡ
		
		char buffer[256];
		DWORD Size=sizeof(buffer);
		typedef BOOL (WINAPI* SETDEFAULTPRINTER)(LPCTSTR pszPrinter);
		typedef BOOL (WINAPI* GETDEFAULTPRINTER)(  LPTSTR pszBuffer, LPDWORD pcchBuffer );
		HINSTANCE hLib = LoadLibrary("WINSPOOL.DRV");
		SETDEFAULTPRINTER SetDefaultPrinter = (SETDEFAULTPRINTER)GetProcAddress(hLib,"SetDefaultPrinterA");
		GETDEFAULTPRINTER GetDefaultPrinter = (GETDEFAULTPRINTER)GetProcAddress(hLib,"GetDefaultPrinterA");
		bSet=GetDefaultPrinter(buffer,&Size);
		Sleep(100);
		if(bSet)
			m_szDefaultPrinter = buffer;
		else
			m_szDefaultPrinter = "";
		bSet = SetDefaultPrinter("docPrint");
		Sleep(100);
		if(hLib)
			FreeLibrary(hLib);
		
		if(!bSet)
		{
			::MessageBox(GetDesktopWindow(),"Please install docPrint Printer first.",NULL,MB_OK);
			return m_szDefaultPrinter;
		}
	}
	catch(...)
	{
		
	}
	return m_szDefaultPrinter;
}
void MyResotreDefaultPrinter(string& m_szDefaultPrinter)
{
	try{
		//ָȱʡĴӡ
		if(m_szDefaultPrinter.size())
		{
			typedef BOOL (WINAPI* SETDEFAULTPRINTER)(LPCTSTR pszPrinter);
			HINSTANCE hLib = LoadLibrary("WINSPOOL.DRV");
			SETDEFAULTPRINTER SetDefaultPrinter = (SETDEFAULTPRINTER)GetProcAddress(hLib,"SetDefaultPrinterA");
			SetDefaultPrinter(m_szDefaultPrinter.c_str());
			if(hLib)
				FreeLibrary(hLib);
			m_szDefaultPrinter = "";
		}
		
	}
	catch(...)
	{
	}
}
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemo_converter_comDlg dialog

CDemo_converter_comDlg::CDemo_converter_comDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemo_converter_comDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemo_converter_comDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemo_converter_comDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemo_converter_comDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemo_converter_comDlg, CDialog)
	//{{AFX_MSG_MAP(CDemo_converter_comDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_PDF2PRINT, OnButtonPdf2print)
	ON_BN_CLICKED(IDC_BUTTON_WORD2PRINT, OnButtonWord2print)
	ON_BN_CLICKED(IDC_BUTTON_XLS2PRINT, OnButtonXls2print)
	ON_BN_CLICKED(IDC_BUTTON_PPT2PRINT, OnButtonPpt2print)
	ON_BN_CLICKED(IDC_BUTTON_VSD2PRINT, OnButtonVsd2print)
	ON_BN_CLICKED(IDC_BUTTON_GDI, OnButtonGdi)
	ON_BN_CLICKED(IDC_BUTTON_EMF, OnButtonEmf)
	ON_BN_CLICKED(IDC_BUTTON_BMP, OnButtonBmp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemo_converter_comDlg message handlers

BOOL CDemo_converter_comDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDemo_converter_comDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemo_converter_comDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDemo_converter_comDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//You need install the full version of Acrobat in order to get this function to work
void CDemo_converter_comDlg::OnButtonPdf2print() 
{
	SetOutputFileName(szOutputFileName);
	static char BASED_CODE szFilter[] = "Adobe Acrobat documents (*.pdf)|*.pdf||";

	CFileDialog dlg( 1, 0, 0, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST, szFilter, 0 );
	if( dlg.DoModal() != IDOK )
		return;

	int iStartTick = GetTickCount();
	int iFileCount = docPrint_DocumentConverter(dlg.m_ofn.lpstrFile,szOutputFileName,NULL);
	int iEndTick = GetTickCount();

	ShellExecute(NULL,"open",szOutputFileName,NULL,NULL,SW_SHOWNORMAL);
}

//You need to install the MS Word in order to get this function to work.
void CDemo_converter_comDlg::OnButtonWord2print() 
{
	SetOutputFileName(szOutputFileName);
	static char BASED_CODE szFilter[] = "MS Word documents (*.doc)|*.doc||";

	CFileDialog dlg( 1, 0, 0, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST, szFilter, 0 );
	if( dlg.DoModal() != IDOK )
		return;

	int iStartTick = GetTickCount();
	int iFileCount = docPrint_DocumentConverter(dlg.m_ofn.lpstrFile,szOutputFileName,NULL);
	int iEndTick = GetTickCount();

	ShellExecute(NULL,"open",szOutputFileName,NULL,NULL,SW_SHOWNORMAL);
}

//You need install MS Excel in order to get this function to work.
void CDemo_converter_comDlg::OnButtonXls2print() 
{
	SetOutputFileName(szOutputFileName);
	static char BASED_CODE szFilter[] = "MS Excel worksheets (*.xls)|*.xls||";

	CFileDialog dlg( 1, 0, 0, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST, szFilter, 0 );
	if( dlg.DoModal() != IDOK )
		return;

	int iStartTick = GetTickCount();
	int iFileCount = docPrint_DocumentConverter(dlg.m_ofn.lpstrFile,szOutputFileName,NULL);
	int iEndTick = GetTickCount();

	ShellExecute(NULL,"open",szOutputFileName,NULL,NULL,SW_SHOWNORMAL);
}

//You need install MS PowerPoint in order to get this function to work.
void CDemo_converter_comDlg::OnButtonPpt2print() 
{
	SetOutputFileName(szOutputFileName);
	static char BASED_CODE szFilter[] = "MS PowerPoint presentations (*.ppt)|*.ppt||";

	CFileDialog dlg( 1, 0, 0, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST, szFilter, 0 );
	if( dlg.DoModal() != IDOK )
		return;

	int iStartTick = GetTickCount();
	int iFileCount = docPrint_DocumentConverter(dlg.m_ofn.lpstrFile,szOutputFileName,NULL);
	int iEndTick = GetTickCount();

	ShellExecute(NULL,"open",szOutputFileName,NULL,NULL,SW_SHOWNORMAL);
}

//You need to install MS Visio in order to get this function to work.
void CDemo_converter_comDlg::OnButtonVsd2print() 
{
	SetOutputFileName(szOutputFileName);
	static char BASED_CODE szFilter[] = "MS Visio drawings (*.vsd)|*.vsd||";

	CFileDialog dlg( 1, 0, 0, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST, szFilter, 0 );
	if( dlg.DoModal() != IDOK )
		return;

	int iStartTick = GetTickCount();
	int iFileCount = docPrint_DocumentConverter(dlg.m_ofn.lpstrFile,szOutputFileName,NULL);
	int iEndTick = GetTickCount();

	ShellExecute(NULL,"open",szOutputFileName,NULL,NULL,SW_SHOWNORMAL);
}

//Print text and lines to docPrint
bool DrawLineAndTextToDocPrint( HANDLE& prnHandle, char* sPrnName, DEVMODE* dm )
{
	HDC		hDC;
	DOCINFO		di = { sizeof(DOCINFO), "Test Printing" };
	char*		str = "Text for printing";
	RECT		rcOut = { 0, 0, 300, 100 };
	POINT		ptArc = { 0, 300 };
	int		oldBKMode = 0;
	RECT		rcTxt = { 0 };

	SetOutputFileName(szOutputFileName);
	hDC = CreateDC( 0, sPrnName, 0, dm );
	if( !hDC )
	{
		ClosePrinter( prnHandle );
		free( dm );
		return 0;
	}

	if( StartDoc( hDC, &di ) == SP_ERROR )
	{
		DeleteDC( hDC );
		ClosePrinter( prnHandle );
		free( dm );
		return 0;
	}

	StartPage( hDC );

	Arc( hDC, rcOut.left, rcOut.top, rcOut.right, rcOut.bottom, ptArc.x, ptArc.y, ptArc.x, ptArc.y );

	oldBKMode = SetBkMode( hDC, TRANSPARENT );

	TextOut(hDC,200,200,str,strlen(str));	

	SetBkMode( hDC, oldBKMode );

	EndPage( hDC );
	EndDoc( hDC );

	DeleteDC( hDC );
	return 1;
}

void CDemo_converter_comDlg::OnButtonGdi() 
{
	SetOutputFileName(szOutputFileName);
	CString		sPrnName = szPrinterName;
	HANDLE		prnHandle = 0;
	PRINTER_DEFAULTS pd = { 0, 0, PRINTER_ACCESS_USE };
	DEVMODE*	dm = 0;
	long		len = 0;

	if( !OpenPrinter( (char*)(LPCTSTR)sPrnName, &prnHandle, &pd ) )
		return;

	len = DocumentProperties( 0, prnHandle, (char*)(LPCTSTR)sPrnName, 0, 0, 0 );
	if( len <= 0  )
	{
		ClosePrinter( prnHandle );
		return;
	}
	dm = (DEVMODE*)malloc( len );

	DocumentProperties( 0, prnHandle, (char*)(LPCTSTR)sPrnName, dm, 0, DM_OUT_BUFFER );

	DrawLineAndTextToDocPrint( prnHandle, (char*)(LPCTSTR)sPrnName, dm );

	ClosePrinter( prnHandle );
	free( dm );
}

void DrawEMFToDocPrint( HANDLE& prnHandle, char* sPrnName, DEVMODE* dm, HENHMETAFILE hMeta )
{
	HDC	hDC;
	DOCINFO	di = { sizeof(DOCINFO), "Metafile Printing" };
	RECT	rcOut = { 0 };
	ENHMETAHEADER	hdr = { 0 };

	SetOutputFileName(szOutputFileName);
	hDC = CreateDC( 0, sPrnName, 0, dm );
	if( !hDC )
	{
		ClosePrinter( prnHandle );
		free( dm );
		return;
	}

	if( StartDoc( hDC, &di ) == SP_ERROR )
	{
		DeleteDC( hDC );
		ClosePrinter( prnHandle );
		free( dm );
		return;
	}

	StartPage( hDC );

	GetEnhMetaFileHeader( hMeta, sizeof( hdr ), &hdr );
	rcOut.right = hdr.rclBounds.right;
	rcOut.bottom = hdr.rclBounds.bottom;

	PlayEnhMetaFile( hDC, hMeta, &rcOut ); 

	EndPage( hDC );
	EndDoc( hDC );

	DeleteDC( hDC );
}

void CDemo_converter_comDlg::OnButtonEmf() 
{
	SetOutputFileName(szOutputFileName);
	CString			sPrnName = szPrinterName;
	HANDLE			prnHandle = 0;
	PRINTER_DEFAULTS pd = { 0, 0, PRINTER_ACCESS_USE };
	DEVMODE*		dm = 0;
	long			len = 0;
	HENHMETAFILE	hMeta = 0;

	static char BASED_CODE szFilter[] = "Enhanced Metafile (*.emf)|*.emf||";

	CFileDialog dlg( 1, 0, 0, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST, szFilter, 0 );
	if( dlg.DoModal() != IDOK )
		return;

	hMeta = GetEnhMetaFile( dlg.m_ofn.lpstrFile ); 
	if( !hMeta )
		return;
	if( !OpenPrinter( (char*)(LPCTSTR)sPrnName, &prnHandle, &pd ) )
	{
		DeleteEnhMetaFile( hMeta );
		return;
	}

	len = DocumentProperties( 0, prnHandle, (char*)(LPCTSTR)sPrnName, 0, 0, 0 );
	if( len <= 0  )
	{
		DeleteEnhMetaFile( hMeta );
		ClosePrinter( prnHandle );
		return;
	}
	dm = (DEVMODE*)malloc( len );

	DocumentProperties( 0, prnHandle, (char*)(LPCTSTR)sPrnName, dm, 0, DM_OUT_BUFFER );

	DrawEMFToDocPrint( prnHandle, (char*)(LPCTSTR)sPrnName, dm, hMeta );

	DeleteEnhMetaFile( hMeta );

	ClosePrinter( prnHandle );
	free( dm );	
}

void DrawBMPToDocPrint( HANDLE& prnHandle, char* sPrnName, DEVMODE* dm, HBITMAP hBmp )
{
	SetOutputFileName(szOutputFileName);
	HDC	hDC = 0, tmpDC = 0;
	DOCINFO	di = { sizeof(DOCINFO), "BMP Printing" };
	HBITMAP	oldBmp = 0;
	BITMAP	info = { 0 };

	hDC = CreateDC( 0, sPrnName, 0, dm );
	if( !hDC )
	{
		ClosePrinter( prnHandle );
		free( dm );
		return;
	}

	if( StartDoc( hDC, &di ) == SP_ERROR )
	{
		DeleteDC( hDC );
		ClosePrinter( prnHandle );
		free( dm );
		return;
	}

	StartPage( hDC );

	tmpDC = CreateCompatibleDC( hDC );
	oldBmp = (HBITMAP)SelectObject( tmpDC, hBmp );

	GetObject( hBmp, sizeof( info ), &info );

	BitBlt( hDC, 0, 0, info.bmWidth, info.bmHeight, tmpDC, 0, 0, SRCCOPY );

	SelectObject( tmpDC, oldBmp );
	DeleteDC( tmpDC );

	EndPage( hDC );
	EndDoc( hDC );

	DeleteDC( hDC );
}
void CDemo_converter_comDlg::OnButtonBmp() 
{
	SetOutputFileName(szOutputFileName);
	CString			sPrnName = szPrinterName;
	HANDLE			prnHandle = 0;
	PRINTER_DEFAULTS pd = { 0, 0, PRINTER_ACCESS_USE };
	DEVMODE*		dm = 0;
	long			len = 0;
	HBITMAP			hBmp = 0;

	static char BASED_CODE szFilter[] = "Windows Bitmap (*.bmp)|*.bmp||";

	CFileDialog dlg( 1, 0, 0, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST, szFilter, 0 );
	if( dlg.DoModal() != IDOK )
		return;

	hBmp = (HBITMAP) LoadImage( 0, dlg.m_ofn.lpstrFile, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE | LR_CREATEDIBSECTION );
	if( !hBmp )
		return;
	if( !OpenPrinter( (char*)(LPCTSTR)sPrnName, &prnHandle, &pd ) )
	{
		DeleteObject( hBmp );
		return;
	}

	len = DocumentProperties( 0, prnHandle, (char*)(LPCTSTR)sPrnName, 0, 0, 0 );
	if( len <= 0  )
	{
		DeleteObject( hBmp );
		ClosePrinter( prnHandle );
		return;
	}
	dm = (DEVMODE*)malloc( len );

	DocumentProperties( 0, prnHandle, (char*)(LPCTSTR)sPrnName, dm, 0, DM_OUT_BUFFER );

	DrawBMPToDocPrint( prnHandle, (char*)(LPCTSTR)sPrnName, dm, hBmp );

	DeleteObject( hBmp );

	ClosePrinter( prnHandle );
	free( dm );	
}
