// demo_converter_vc.cpp : Defines the entry point for the console application.
//

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string>
#include <vector>
using namespace std;

char m_szIniFilename[MAX_PATH];
int  m_iWaitTime = 30;

BOOL GetConfigFilePath(char *m_szDesktopPrograms, int length)
{
	HKEY hCU;    
	DWORD dwType;    
	ULONG ulSize = MAX_PATH;
	HKEY hrkey = HKEY_CURRENT_USER;

	memset(m_szDesktopPrograms,0,length);
	hrkey = HKEY_LOCAL_MACHINE;
	if (RegOpenKeyEx(hrkey, 
		"SOFTWARE\\verypdf\\docprint", 
		0,KEY_QUERY_VALUE,&hCU) == ERROR_SUCCESS)
	{
		RegQueryValueEx(hCU,        
			//"Personal",
			"ConfigFile",
			NULL,        
			&dwType,
			(unsigned char *)m_szDesktopPrograms,        
			&ulSize);      
		RegCloseKey(hCU);    
	}
	else
		return FALSE;
	return TRUE;
}
void InitialIniFileName()
{
	GetConfigFilePath(m_szIniFilename,MAX_PATH);
}
string MyGetDefaultPrinter()
{
	string m_szDefaultPrinter;
	try{
		int bSet = 0;
		//ΪȱʡĴӡ
		
		char buffer[256];
		DWORD Size=sizeof(buffer);
		typedef BOOL (WINAPI* SETDEFAULTPRINTER)(LPCTSTR pszPrinter);
		typedef BOOL (WINAPI* GETDEFAULTPRINTER)(  LPTSTR pszBuffer, LPDWORD pcchBuffer );
		HINSTANCE hLib = LoadLibrary("WINSPOOL.DRV");
		SETDEFAULTPRINTER SetDefaultPrinter = (SETDEFAULTPRINTER)GetProcAddress(hLib,"SetDefaultPrinterA");
		GETDEFAULTPRINTER GetDefaultPrinter = (GETDEFAULTPRINTER)GetProcAddress(hLib,"GetDefaultPrinterA");
		bSet=GetDefaultPrinter(buffer,&Size);
		Sleep(100);
		if(bSet)
			m_szDefaultPrinter = buffer;
		else
			m_szDefaultPrinter = "";
		bSet = SetDefaultPrinter("docPrint");
		Sleep(100);
		if(hLib)
			FreeLibrary(hLib);
		
		if(!bSet)
		{
			::MessageBox(GetDesktopWindow(),"Please install docPrint Printer first.",NULL,MB_OK);
			return m_szDefaultPrinter;
		}
	}
	catch(...)
	{
		
	}
	return m_szDefaultPrinter;
}
void MyResotreDefaultPrinter(string& m_szDefaultPrinter)
{
	try{
		//ָȱʡĴӡ
		if(m_szDefaultPrinter.size())
		{
			typedef BOOL (WINAPI* SETDEFAULTPRINTER)(LPCTSTR pszPrinter);
			HINSTANCE hLib = LoadLibrary("WINSPOOL.DRV");
			SETDEFAULTPRINTER SetDefaultPrinter = (SETDEFAULTPRINTER)GetProcAddress(hLib,"SetDefaultPrinterA");
			SetDefaultPrinter(m_szDefaultPrinter.c_str());
			if(hLib)
				FreeLibrary(hLib);
			m_szDefaultPrinter = "";
		}
		
	}
	catch(...)
	{
	}
}
BOOL docPrintConverter(const char *m_ptrDocFile,const char* m_ptrOutputFile)
{
	if(m_ptrDocFile == NULL || m_ptrDocFile[0] == 0 || m_ptrOutputFile == NULL
		|| m_ptrOutputFile[0] == 0)
		return FALSE;

	//Set the output filename to docPrint
	WritePrivateProfileString("AutoSave","IsAutoSave","1",m_szIniFilename);
	WritePrivateProfileString("AutoSave","OutputFile",m_ptrOutputFile,m_szIniFilename);

	WritePrivateProfileString("AutoSaveOptions","m_bCreateFileForEachPage","1",m_szIniFilename);
	WritePrivateProfileString("AutoSaveOptions","m_strColorDepth","24",m_szIniFilename);
	WritePrivateProfileString("AutoSaveOptions","m_strResolution","200x200",m_szIniFilename);
	WritePrivateProfileString("AutoSaveOptions","m_bGrayscale","0",m_szIniFilename);
	//Use run length compression arithmetic for TIFF file
	WritePrivateProfileString("AutoSaveOptions",".tif","-compress rle",m_szIniFilename);

	//Call the associated application to print this document to docPrint 
	string m_szDefaultPrinter = MyGetDefaultPrinter();
	SHELLEXECUTEINFO ShExecInfo = {0};
	ShExecInfo.cbSize = sizeof(SHELLEXECUTEINFO);
	ShExecInfo.fMask = SEE_MASK_NOCLOSEPROCESS;
	ShExecInfo.hwnd = NULL;
	ShExecInfo.lpVerb = "print";
	ShExecInfo.lpFile = m_ptrDocFile;             
	ShExecInfo.lpParameters = "";  
	ShExecInfo.lpDirectory = NULL;
	ShExecInfo.nShow = SW_SHOWMINIMIZED;
	ShExecInfo.hInstApp = NULL;    
	ShellExecuteEx(&ShExecInfo);
	if(WaitForSingleObject(ShExecInfo.hProcess,m_iWaitTime*1000) == WAIT_TIMEOUT)
	{
		while(1)
		{
			DWORD ExitCode;
			if(GetExitCodeProcess(ShExecInfo.hProcess,&ExitCode))
			{
				if(ExitCode == STILL_ACTIVE)
				{
					Sleep(500);
					int result = TerminateProcess(ShExecInfo.hProcess,0);
				}
				else
					break;
			}
			else
			{
				int result = GetLastError();
				break;
			}
		}
	}
	CloseHandle(ShExecInfo.hProcess);
	MyResotreDefaultPrinter(m_szDefaultPrinter);
	
	struct _stat m_statBuf;
	if(_stat(m_ptrOutputFile,&m_statBuf) != 0)
		return FALSE;
	return TRUE;
}

int main(int argc, char* argv[])
{
	if(argc != 3)
	{
		printf("Usage:\n");
		printf("\"%s\" \"C:\\input.doc\" \"C:\\input.tif\"\n",argv[0]);
		printf("\"%s\" \"C:\\input.doc\" \"C:\\input.jpg\"\n",argv[0]);
		printf("\"%s\" \"C:\\input.doc\" \"C:\\input.bmp\"\n",argv[0]);
		printf("\"%s\" \"C:\\input.doc\" \"C:\\input.emf\"\n",argv[0]);
		return 0;
	}
	const char *m_ptrDocFile = argv[1];
	const char *m_ptrOutputFile = argv[2];
	InitialIniFileName();
	BOOL m_bRet = docPrintConverter(m_ptrDocFile,m_ptrOutputFile);
	printf("%s ==> %s",m_ptrDocFile,m_ptrOutputFile);
	return 1;
}
