unit Unit1;

interface

uses
  Windows, Messages, SysUtils,  Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComObj, Printers, ExtCtrls,ShellApi, ShlObj;

Function docPrint_Register(lpRegCode: PChar; lpCompanyName: PChar) : longint; stdcall; external 'doc2img.dll' name 'docPrint_Register';
Function docPrint_SetOptions(lpKeyName: PChar; lpString: PChar) : longint; stdcall; external 'doc2img.dll' name 'docPrint_SetOptions';
Function docPrint_DocumentConverter(lpDocFile: PChar; lpOutputFile: PChar; lpOptions: PChar) : longint; stdcall; external 'doc2img.dll' name 'docPrint_DocumentConverter';
Function docPrint_ChangePrinterSettings(Source: PChar; lpDevMode: PDevMode) : longint; stdcall; external 'doc2img.dll' name 'docPrint_ChangePrinterSettings';
Function docPrint_KillProcess(lpProcessName: PChar) : longint; stdcall; external 'doc2img.dll' name 'docPrint_KillProcess';

type
  TForm1 = class(TForm)
    Button6: TButton;
    Button7: TButton;
    FileDlg: TOpenDialog;
    Image: TImage;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button8: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetOutputFileName(m_ptrOutputFile: String);
  end;

    //Private Declare Function SetDefaultPrinter Lib "winspool.drv" Alias _
    //"SetDefaultPrinterA" (ByVal pszbuffer As String) As Long
  procedure SetDefaultPrinter(pszbuffer: String);stdcall; external 'winspool.drv' name 'SetDefaultPrinterA';

var
  Form1: TForm1;

Const sPrinterName = 'docPrint';
Const m_szIniFilename = 'C:\Program Files\docPrint Pro v3.3\option.ini' ;
Const szOutputFileName = 'C:\docPrint_output.tif';

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
     wordApp: Variant;
     wDoc: Variant;
begin
    SetOutputFileName(szOutputFileName);
    FileDlg.Options := [ofHideReadOnly,ofPathMustExist,ofFileMustExist,ofNoLongNames,ofEnableSizing];
    FileDlg.Filter := 'MS Word documents (*.doc)|*.doc';
    FileDlg.FilterIndex := 1;
    if (not FileDlg.Execute()) then
        exit;;
    try

      docPrint_DocumentConverter(PChar(FileDlg.FileName), PChar('c:\yos.tif'), PChar('-c 1'));
      {wordApp := CreateOleObject('Word.Application');
      wDoc := wordApp.Documents.Open(FileDlg.FileName, , 1);
      wordApp.ActivePrinter := sPrinterName;
      wordApp.PrintOut(False);}
    finally
      {wDoc.Close;
      wordApp.Quit;}

    end;

End;

procedure TForm1.SetOutputFileName(m_ptrOutputFile: String);
begin

    SetDefaultPrinter(sPrinterName);
    //Set the output filename to docPrint
    WritePrivateProfileString('AutoSave', 'IsAutoSave', '1', m_szIniFilename);
    WritePrivateProfileString('AutoSave', 'OutputFile', PChar(m_ptrOutputFile), m_szIniFilename);

    WritePrivateProfileString('AutoSaveOptions', 'm_bCreateFileForEachPage', '1', m_szIniFilename);
    WritePrivateProfileString('AutoSaveOptions', 'm_strColorDepth', '24', m_szIniFilename);
    WritePrivateProfileString('AutoSaveOptions', 'm_strResolution', '200x200', m_szIniFilename);
    WritePrivateProfileString('AutoSaveOptions', 'm_bGrayscale', '0', m_szIniFilename);
End;

procedure TForm1.Button6Click(Sender: TObject);
var
    Msg: String;
    HWidth: Real;
    HHeight: Real;
    Rect: TRect;
    prt: TPrinter;
begin

    SetOutputFileName(szOutputFileName);

    printer.BeginDoc;
    Msg := 'Test GDI functions from Delphi codes';
    HWidth := Printer.Canvas.TextWidth(Msg) / 2.0;   // Get half width.
    HHeight := Printer.Canvas.TextHeight(Msg) / 2.0;  // Get half height.
    Printer.Canvas.MoveTo(Round(Printer.PageWidth / 2.0 - HWidth), Round(Printer.PageHeight / 2.0 - HHeight));
    Printer.Canvas.TextOut(3100, 300, Msg);
    Rect.Left := 100;//1200 - Round(Printer.PageWidth / 2);
    Rect.Right := 600;//1200 + Round(Printer.PageWidth / 2);
    Rect.Top := 100;//1200 - Round(Printer.PageHeight / 2);
    Rect.Bottom := 600;//1200 + Round(Printer.PageHeight / 2);
    Printer.Canvas.Ellipse(Rect);
    //Printer.Canvas.e(Printer.ScaleWidth / 2, Printer.ScaleHeight / 2), 1200, RGB(255, 0, 0);
    Printer.EndDoc   // Printing is finished.


end;

procedure TForm1.Button7Click(Sender: TObject);

begin

    try

    FileDlg.Filter := 'Image file (Bitmap, JPEG, GIF or Metafile)|*.bmp;*.jpg;*.gif;*.wmf;*.emf';

    FileDlg.FilterIndex := 1;

    if (not FileDlg.Execute) then
        exit;

    Image.Picture.LoadFromFile(FileDlg.FileName);
    printer.BeginDoc;
    SetOutputFileName(szOutputFileName);

    Printer.Canvas.Draw(0, 0, TGraphic(Image.Picture.Bitmap));

    Printer.EndDoc   // Printing is finished.

    
except
end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
     exclApp: Variant;
     xlWB: Variant;
begin
    SetOutputFileName(szOutputFileName);
    FileDlg.Options := [ofHideReadOnly,ofPathMustExist,ofFileMustExist,ofNoLongNames,ofEnableSizing];
    FileDlg.Filter := 'MS Excel worksheets (*.xls)|*.xls';
    FileDlg.FilterIndex := 1;
    if (not FileDlg.Execute()) then
        exit;;
    try
      exclApp := CreateOleObject('Excel.Application');
      xlWB := exclApp.Workbooks.Open(FileDlg.FileName, , True);
     // exclApp.ActivePrinter := sPrinterName;
      exclApp.Worksheets.PrintOut(, , , , sPrinterName);
    finally
      xlWB.Close;
      exclApp.Quit;

    end;

End;

procedure TForm1.Button3Click(Sender: TObject);

var
     ppPresent: Variant;
     pptApp: Variant;
begin
    SetOutputFileName(szOutputFileName);
    FileDlg.Options := [ofHideReadOnly,ofPathMustExist,ofFileMustExist,ofNoLongNames,ofEnableSizing];
    FileDlg.Filter := 'MS PowerPoint presentations (*.ppt)|*.ppt';
    FileDlg.FilterIndex := 1;
    if (not FileDlg.Execute()) then
        exit;;
    try
      pptApp := CreateOleObject('PowerPoint.Application');
      ppPresent := pptApp.Presentations.Open(FileDlg.FileName, 1, 1, 0);
      ppPresent.PrintOptions.ActivePrinter := sPrinterName;
      ppPresent.PrintOptions.PrintInBackground := False;
      ppPresent.PrintOptions.PrintColorType := 1 ;
      ppPresent.PrintOut(1, True);
      ppPresent.Saved := True;
    finally
      ppPresent.Close;
      pptApp.Quit;

    end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
        nDevMode:   DEVMODE;
begin
	nDevMode.dmFields := DM_PRINTQUALITY+DM_YRESOLUTION;
	nDevMode.dmPrintQuality := 100;
	nDevMode.dmYResolution := 100;
	docPrint_ChangePrinterSettings('docPrint',@nDevMode);
end;

procedure TForm1.Button5Click(Sender: TObject);
var
        ShExecInfo: TShellExecuteInfo;
begin
        SetOutputFileName(szOutputFileName);
        FileDlg.Options := [ofHideReadOnly,ofPathMustExist,ofFileMustExist,ofNoLongNames,ofEnableSizing];
        FileDlg.Filter := 'Adobe PDF File (*.pdf)|*.pdf';
        FileDlg.FilterIndex := 1;
        if (not FileDlg.Execute()) then
            exit;
        try
          ShExecInfo.cbSize         := Sizeof(ShExecInfo);
          ShExecInfo.fMask          := SEE_MASK_NOCLOSEPROCESS;
          ShExecInfo.lpVerb         := 'print';
          ShExecInfo.lpFile         := PChar(FileDlg.FileName);
          ShExecInfo.lpParameters   := '';
          ShExecInfo.lpDirectory    := '';
          ShExecInfo.nShow          := SW_HIDE;
          ShExecInfo.hInstApp       := 0;
          ShellExecuteEx(@ShExecInfo);
        finally
        docPrint_KillProcess('AcroRd32.exe');
        end;
end;

procedure TForm1.Button8Click(Sender: TObject);
var
  nDevMode : DEVMODE;
  Options  : String;
  rslt     : integer;
  convsec  : integer;
  t1,t2    : longint;
Const
  OutPutConvFile : String = 'c:\temp\cnv.tif';
begin

    SetOutputFileName(szOutputFileName);
    FileDlg.Options := [ofHideReadOnly,ofPathMustExist,ofFileMustExist,ofNoLongNames,ofEnableSizing];
    FileDlg.Filter := 'MS Word documents (*.doc)|*.doc';
    FileDlg.FilterIndex := 1;
    if (not FileDlg.Execute()) then
        exit;;

//    nDevMode.dmFields := DM_PRINTQUALITY+DM_YRESOLUTION;
//    nDevMode.dmPrintQuality := 200;
//    nDevMode.dmYResolution := 200;
//    nDevMode.dmColor := DMCOLOR_MONOCHROME;
//    docPrint_ChangePrinterSettings('docPrint',@nDevMode);

//    docPrint_SetOptions(Pchar('m_bCreateFileForEachPage'),Pchar('1'));
//    docPrint_SetOptions(Pchar('m_strColorDepth'),Pchar('24'));
//    docPrint_SetOptions(Pchar('m_strResolution'),Pchar('300x300'));
//    docPrint_SetOptions(Pchar('m_bGrayscale'),Pchar('0'));
//    Use run length compression arithmetic for TIFF file
//    docPrint_SetOptions(Pchar('.tif'),Pchar('-compress rle'));
//    docPrint_SetOptions(".tif","-compress lzw");
//    docPrint_SetOptions(Pchar('.jpg'),Pchar('-quality 100'));


    //Please run following command line to get more options for doc2pdf converter
    //C:\>"C:\Program Files\docPrint Pro v3.3\doc2pdf.exe" -?
    //
    //-j <Subject>        : subject
    //-t <Title>          : title
    //-a <Author>         : author
    //-k <Keywords>       : keywords
    //-g <Page range>     : page range for conversion, eg: 1,2-4,6
    //-G                  : don't append suffix to filename for single page file
    //-p <Output Flag>    : a flag for PDF output
    //   -p 0: overwrite if PDF file exists
    //   -p 1: insert before first page if PDF file exists
    //   -p 2: append to last page if PDF file exists
    //   -p 3: rename filename if PDF file exists
    //-b <Color type>    : specify color type for output file
    //   -b 1: output black and white image file
    //   -b 8: output 256 colors image file
    //   -b 24: output True Colors image file
    //-R <Rotate>        : rotate page 90, 180, 270 angle
    //-r <resolution>    : set resolution in generated image file
    //   -r 300      : set X and Y resolution within document to image conversion
    //   -r 300x600  : set X and Y resolution within document to image conversion
    //   -r 200x300  : set X and Y resolution within document to image conversion
    //-w <image width>   : fix the paper width within document to image conversion
    //-h <image height>  : fix the paper height within document to image conversion
    //-f <paper size>    : set the paper size for HTML and XLS to PDF conversion
    //-z <PrintZoomPaper>: set print zoom paper for MS Office document printing
    //    -z 12240x15840 : scale to Letter print paper size
    //    -z 11907x16839 : scale to A4 print paper size
    //-V                 : view the generated PDF file automatically
    //-d                 : hide MS Office printing dialog within conversion

    t1 := GetTickCount;

    rslt := 0; // for demo try
// after purchased the product you will get a code to run convertion in registed mode
    // rslt := docPrint_Register(Pchar('XXXXXXXXXXXXXX'),Pchar('Corp System'));

    IF rslt <> 0 Then
      raise exception.create('wrong register code');

    Options := ' -r 200x200 -f ''215.9x279.4mm'' -b 1 -c 4 -D';
    IF FileExists(OutPutConvFile) Then
      DeleteFile(OutPutConvFile);
    rslt := docPrint_DocumentConverter(Pchar(FileDlg.FileName),Pchar(OutPutConvFile), Pchar(Options));
    IF rslt <> 0 Then
      raise exception.create('convert fail');
    t2 := GetTickCount;
    convsec := Trunc((t2 - t1) / 1000);
    showmessage('convert finish in ' + IntToStr(convsec) + ' sec');
end;

end.
