﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace PDFManager
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void OpenPDF_Click(object sender, EventArgs e)
        {
            OpenFileDialog openExtensFile = new OpenFileDialog();
            openExtensFile.Title = "PDF";
            openExtensFile.InitialDirectory = @"D:\downloads";
            openExtensFile.Filter = "PDF Files (*.pdf)|*.pdf|All Files (*.*)|*.*";
            openExtensFile.FilterIndex = 0;
            openExtensFile.RestoreDirectory = true;
            if (openExtensFile.ShowDialog() == DialogResult.OK)
            {
                ocx.OpenPDFFile(openExtensFile.FileName, "", "", 0);
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ocx.SetOrderID("XXXXXXXXXXXXXXXXXXXXX", null, null);
            ocx.MainToolbarDeleteButton(26);
            ocx.MainToolbarDeleteButton(25);
            ocx.MainToolbarDeleteButton(24);
            ocx.MainToolbarDeleteButton(23);
            ocx.MainToolbarDeleteButton(22);
            ocx.MainToolbarDeleteButton(21);
            ocx.MainToolbarDeleteButton(20);
            ocx.MainToolbarDeleteButton(19);
            ocx.MainToolbarDeleteButton(18);
            ocx.MainToolbarDeleteButton(10);
            ocx.MainToolbarDeleteButton(9);
            ocx.MainToolbarDeleteButton(8);
            ocx.MainToolbarDeleteButton(7);
            ocx.MainToolbarDeleteButton(6);
            ocx.MainToolbarDeleteButton(5);
            ocx.MainToolbarDeleteButton(4);
            ocx.MainToolbarDeleteButton(3);
            ocx.MainToolbarDeleteButton(2);
            ocx.MainToolbarDeleteButton(1);
            ocx.MainToolbarDeleteButton(0);
            ocx.InvokeMethodEx(42, 1, "");//Edit Comment Buttons

            ocx.Height = this.Height - 100;
            ocx.Width = this.Width - 50;
        }

        private void SavePDF_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveExtensFile = new SaveFileDialog();
            saveExtensFile.Title = "PDF";
            saveExtensFile.InitialDirectory = @"D:\downloads";
            saveExtensFile.Filter = "PDF Files (*.pdf)|*.pdf|All Files (*.*)|*.*";
            saveExtensFile.FilterIndex = 0;
            saveExtensFile.RestoreDirectory = true;
            if (saveExtensFile.ShowDialog() == DialogResult.OK)
            {
                ocx.SavePDFFile(saveExtensFile.FileName);
            }
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            ocx.Height = this.Height - 100;
            ocx.Width = this.Width - 50;
        }

        private void About_Click(object sender, EventArgs e)
        {
            ocx.AboutBox();
        }

        private void Button_Search_Click(object sender, EventArgs e)
        {
            int lParam = 0;
            ocx.InvokeMethod(85, 0, ref lParam);
        }
    }
}
