﻿Imports System
Imports System.Runtime.InteropServices
Imports System.Diagnostics

Public Class Form1

    Public Const ID_TOOLBAR_OPEN As Long = 32772
    Public Const ID_TOOLBAR_SAVE As Long = 32774
    Public Const ID_TOOLBAR_PRINT As Long = 32773
    Public Const ID_TOOLBAR_EMAIL As Long = 32776
    Public Const ID_TOOLBAR_HAND As Long = 32777
    Public Const ID_TOOLBAR_COMMENT As Long = 32778
    Public Const ID_TOOLBAR_CONTENT As Long = 32779
    Public Const ID_TOOLBAR_FORM As Long = 32877
    Public Const ID_TOOLBAR_LINKTOOL As Long = 32878
    Public Const ID_TOOLBAR_COMMENT_TEXT As Long = 32780
    Public Const ID_TOOLBAR_COMMENT_NOTE As Long = 32781
    Public Const ID_TOOLBAR_COMMENT_STAMP As Long = 32782
    Public Const ID_TOOLBAR_COMMENT_PENCIL As Long = 32783
    Public Const ID_TOOLBAR_COMMENT_LINE As Long = 32784
    Public Const ID_TOOLBAR_COMMENT_RECTANGLE As Long = 32785
    Public Const ID_TOOLBAR_COMMENT_ELLIPSE As Long = 32786
    Public Const ID_TOOLBAR_CONTENT_TEXT As Long = 32787
    Public Const ID_TOOLBAR_CONTENT_LINE As Long = 32788
    Public Const ID_TOOLBAR_CONTENT_RECTANGLE As Long = 32789
    Public Const ID_TOOLBAR_CONTENT_ELLIPSE As Long = 32790
    Public Const ID_TOOLBAR_CONTENT_POLYLINE As Long = 32791
    Public Const ID_TOOLBAR_SELECT_TEXT As Long = 32792
    Public Const ID_TOOLBAR_SELECT_IMAGE As Long = 32793

    Private Const WM_MOUSEFIRST As Long = &H200
    Private Const WM_MOUSEMOVE As Long = &H200
    Private Const WM_LBUTTONDOWN As Long = &H201
    Private Const WM_LBUTTONUP As Long = &H202
    Private Const WM_LBUTTONDBLCLK As Long = &H203
    Private Const WM_RBUTTONDOWN As Long = &H204
    Private Const WM_RBUTTONUP As Long = &H205
    Private Const WM_RBUTTONDBLCLK As Long = &H206
    Private Const WM_MBUTTONDOWN As Long = &H207
    Private Const WM_MBUTTONUP As Long = &H208
    Private Const WM_MBUTTONDBLCLK As Long = &H209
    Private Const WM_MOUSEWHEEL As Long = &H20A
    Private Const WM_MOUSEHWHEEL As Long = &H20E

    Public Const WM_USER = &H400
    'Messages for SetMessageCallbackFunc() function
    Public Const WM_MESSAGECALLBACK As Long = (WM_USER + 1001)
    Public Const WM_ADD_COMMENT_FINISHED As Long = (WM_USER + 1014)
    Public Const WM_SELECT_A_COMMENT As Long = (WM_USER + 1015)
    Public Const WM_SELECT_A_TEXTAREA As Long = (WM_USER + 1016)
    Public Const WM_SELECT_A_TEXTAREA_BEGIN As Long = (WM_USER + 1017)
    Public Const WM_SELECT_A_TEXTAREA_PROCESSING As Long = (WM_USER + 1018)
    Public Const WM_ADD_COMMENT_GET_PREDEFINED_TEXT As Long = (WM_USER + 1019)
    Public Const WM_ADD_COMMENT_CLICK As Long = (WM_USER + 1020)



    Private Sub Button_About_Click(sender As System.Object, e As System.EventArgs) Handles Button_About.Click
        ocx.AboutBox()
    End Sub

    Private Sub Button_OpenPDF_Click(sender As System.Object, e As System.EventArgs) Handles Button_OpenPDF.Click
        Dim fd As OpenFileDialog = New OpenFileDialog()

        fd.Title = "Open PDF File Dialog"
        fd.InitialDirectory = "C:\"
        fd.Filter = "PDF Files (*.pdf)|*.pdf|All Files (*.*)|*.*"
        fd.FilterIndex = 0
        fd.RestoreDirectory = True

        If fd.ShowDialog() = DialogResult.OK Then
            ocx.OpenPDFFile(fd.FileName, "", "", 0)
        End If
    End Sub

    Private Sub Button_SavePDF_Click(sender As System.Object, e As System.EventArgs) Handles Button_SavePDF.Click
        Dim fd As SaveFileDialog = New SaveFileDialog()
        fd.Title = "PDF"
        fd.InitialDirectory = "D:\"
        fd.Filter = "PDF Files (*.pdf)|*.pdf|All Files (*.*)|*.*"
        fd.FilterIndex = 0
        fd.RestoreDirectory = True
        If fd.ShowDialog() = DialogResult.OK Then
            ocx.SavePDFFile(fd.FileName)
        End If
    End Sub

    Private Sub Form1_Resize(sender As System.Object, e As System.EventArgs) Handles MyBase.Resize
        Dim myControl As Control
        myControl = sender

        ocx.Width = myControl.Size.Width - 20
        ocx.Height = myControl.Size.Height - 80
    End Sub

    'StructLayoutAttribute with Sequential layout kind should be appended to PInvoke structs
    Friend Structure MSG
        Public hWnd As IntPtr
        Public message As Integer
        Public wParam As Integer
        Public lParam As Integer 'Maybe you will want to put IntPtr here
        Public time As Integer
        Public pt As POINT
    End Structure

    Friend Structure POINT
        Public x As Integer
        Public y As Integer
    End Structure

    Function ShowClickedButton(ByVal iButtonID As Integer) As Integer
        Dim strMessage As String
        Select Case iButtonID
            Case ID_TOOLBAR_OPEN
                strMessage = "ID_TOOLBAR_OPEN button clicked."
            Case ID_TOOLBAR_SAVE
                strMessage = "ID_TOOLBAR_SAVE button clicked."
            Case ID_TOOLBAR_PRINT
                strMessage = "ID_TOOLBAR_PRINT button clicked."
            Case ID_TOOLBAR_EMAIL
                strMessage = "ID_TOOLBAR_EMAIL button clicked."
            Case ID_TOOLBAR_HAND
                strMessage = "ID_TOOLBAR_HAND button clicked."
            Case ID_TOOLBAR_COMMENT
                strMessage = "ID_TOOLBAR_COMMENT button clicked."
            Case ID_TOOLBAR_CONTENT
                strMessage = "ID_TOOLBAR_CONTENT button clicked."
            Case ID_TOOLBAR_FORM
                strMessage = "ID_TOOLBAR_FORM button clicked."
            Case ID_TOOLBAR_LINKTOOL
                strMessage = "ID_TOOLBAR_LINKTOOL button clicked."
            Case ID_TOOLBAR_COMMENT_TEXT
                strMessage = "ID_TOOLBAR_COMMENT_TEXT button clicked."
            Case ID_TOOLBAR_COMMENT_NOTE
                strMessage = "ID_TOOLBAR_COMMENT_NOTE button clicked."
            Case ID_TOOLBAR_COMMENT_STAMP
                strMessage = "ID_TOOLBAR_COMMENT_STAMP button clicked."
            Case ID_TOOLBAR_COMMENT_PENCIL
                strMessage = "ID_TOOLBAR_COMMENT_PENCIL button clicked."
            Case ID_TOOLBAR_COMMENT_LINE
                strMessage = "ID_TOOLBAR_COMMENT_LINE button clicked."
            Case ID_TOOLBAR_COMMENT_RECTANGLE
                strMessage = "ID_TOOLBAR_COMMENT_RECTANGLE button clicked."
            Case ID_TOOLBAR_COMMENT_ELLIPSE
                strMessage = "ID_TOOLBAR_COMMENT_ELLIPSE button clicked."
            Case ID_TOOLBAR_CONTENT_TEXT
                strMessage = "ID_TOOLBAR_CONTENT_TEXT button clicked."
            Case ID_TOOLBAR_CONTENT_LINE
                strMessage = "ID_TOOLBAR_CONTENT_LINE button clicked."
            Case ID_TOOLBAR_CONTENT_RECTANGLE
                strMessage = "ID_TOOLBAR_CONTENT_RECTANGLE button clicked."
            Case ID_TOOLBAR_CONTENT_ELLIPSE
                strMessage = "ID_TOOLBAR_CONTENT_ELLIPSE button clicked."
            Case ID_TOOLBAR_CONTENT_POLYLINE
                strMessage = "ID_TOOLBAR_CONTENT_POLYLINE button clicked."
            Case ID_TOOLBAR_SELECT_TEXT
                strMessage = "ID_TOOLBAR_SELECT_TEXT button clicked."
            Case ID_TOOLBAR_SELECT_IMAGE
                strMessage = "ID_TOOLBAR_SELECT_IMAGE button clicked."
            Case Else
                strMessage = "Nothing"
        End Select

        Debug.WriteLine(strMessage)
        ShowClickedButton = 0
    End Function

    Function GlobalMessageCallback(ByVal hWnd As IntPtr, ByVal message As Integer, ByVal wParam As Integer, ByVal lParam As Integer, ByVal lUserData As Integer) As Integer

        Dim strMessage As String
        strMessage = "GlobalMessageCallback: Msg=" & message
        Console.WriteLine(strMessage)

        Select Case message
            Case WM_RBUTTONDOWN
                Debug.WriteLine("WM_RBUTTONDOWN")
            Case WM_RBUTTONUP
                Debug.WriteLine("WM_RBUTTONUP")
            Case WM_LBUTTONDOWN
                Debug.WriteLine("WM_LBUTTONDOWN")
            Case WM_LBUTTONUP
                Debug.WriteLine("WM_LBUTTONUP")
            Case WM_MOUSEMOVE
                Debug.WriteLine("WM_MOUSEMOVE")
            Case WM_ADD_COMMENT_FINISHED
                Debug.WriteLine("WM_ADD_COMMENT_FINISHED")
            Case WM_SELECT_A_COMMENT
                Debug.WriteLine("WM_SELECT_A_COMMENT")
            Case WM_SELECT_A_TEXTAREA
                Debug.WriteLine("WM_SELECT_A_TEXTAREA")
            Case WM_ADD_COMMENT_GET_PREDEFINED_TEXT
                Debug.WriteLine("WM_ADD_COMMENT_GET_PREDEFINED_TEXT")
            Case WM_ADD_COMMENT_CLICK
                Debug.WriteLine("WM_ADD_COMMENT_CLICK")
                Dim ret As Integer
                ret = ShowClickedButton(wParam)
        End Select

        GlobalMessageCallback = 0
    End Function


    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)
        If m.Msg = WM_MESSAGECALLBACK Then
            'call  method to process this message
            Dim msg As MSG
            msg = CType(Marshal.PtrToStructure(m.WParam, GetType(MSG)), MSG)

            Dim ret As Integer
            ret = GlobalMessageCallback(msg.hWnd, msg.message, msg.wParam, msg.lParam, m.LParam)
        Else
            'the following code must be retained
            MyBase.WndProc(m)
        End If
    End Sub

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load

        ocx.SetOrderID("XXXXXXXXXXXXXXXXXXXXX", "VeryPDF.com Inc.", "support@verypdf.com")
        ocx.SetMessageCallback(Me.Handle, WM_MESSAGECALLBACK, 0)

    End Sub

    Private Sub Button_Search_Click(sender As System.Object, e As System.EventArgs) Handles Button_Search.Click
        Dim lParam As Integer
        lParam = 0
        ocx.InvokeMethod(85, 0, lParam)
    End Sub
End Class
