// testpdfocxDlg.cpp : implementation file
//

#include "stdafx.h"
#include "testpdfocx.h"
#include "testpdfocxDlg.h"
#include "ocxdefine.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TOP_MARGIN	50

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestpdfocxDlg dialog

CTestpdfocxDlg::CTestpdfocxDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestpdfocxDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestpdfocxDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestpdfocxDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestpdfocxDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestpdfocxDlg, CDialog)
	//{{AFX_MSG_MAP(CTestpdfocxDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_SIZE()
	ON_MESSAGE(WM_MESSAGECALLBACK, OnMessageCallback)
	ON_BN_CLICKED(IDC_BUTTON_GETTEXT, OnButtonGettext)
	ON_BN_CLICKED(IDC_BUTTON_HIDEBUTTONS, OnButtonHidebuttons)
	ON_BN_CLICKED(IDC_BUTTON_SHOWBUTTONS, OnButtonShowbuttons)
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON_PDF2IMAGE, OnButtonPdf2image)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_ICON, OnButtonSelectIcon)
	ON_BN_CLICKED(IDC_BUTTON_CLOSEPDF, OnButtonClosepdf)
	ON_BN_CLICKED(IDC_BUTTON_ISMODIFIED, OnButtonIsmodified)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestpdfocxDlg message handlers
void DrawLines(CDC *pDC,CRect m_nSelectedCellRect,BOOL bErase)
{
	int Width = 5;
	COLORREF m_ForeColor = RGB(0,0,255);
	if(bErase)
		m_ForeColor = RGB(255,255,255);
	CPen  pen(PS_SOLID,Width,m_ForeColor);
	CPen* OldPen = (CPen*)pDC->SelectObject(&pen);
	pDC->MoveTo(m_nSelectedCellRect.left,m_nSelectedCellRect.top);
	pDC->LineTo(m_nSelectedCellRect.right,m_nSelectedCellRect.top);
	pDC->LineTo(m_nSelectedCellRect.right,m_nSelectedCellRect.bottom);
	pDC->LineTo(m_nSelectedCellRect.left,m_nSelectedCellRect.bottom);
	pDC->LineTo(m_nSelectedCellRect.left,m_nSelectedCellRect.top);
	pDC->SelectObject(OldPen);
}
void ShowClickedButton(int iButtonID)
{
	CString strMessage;
	switch(iButtonID)
	{
	case ID_TOOLBAR_OPEN:
		strMessage = "ID_TOOLBAR_OPEN button clicked.";
		break;
	case ID_TOOLBAR_SAVE:
		strMessage = "ID_TOOLBAR_SAVE button clicked.";
		break;
	case ID_TOOLBAR_PRINT:
		strMessage = "ID_TOOLBAR_PRINT button clicked.";
		break;
	case ID_TOOLBAR_EMAIL:
		strMessage = "ID_TOOLBAR_EMAIL button clicked.";
		break;
	case ID_TOOLBAR_HAND:
		strMessage = "ID_TOOLBAR_HAND button clicked.";
		break;
	case ID_TOOLBAR_COMMENT:
		strMessage = "ID_TOOLBAR_COMMENT button clicked.";
		break;
	case ID_TOOLBAR_CONTENT:
		strMessage = "ID_TOOLBAR_CONTENT button clicked.";
		break;
	case ID_TOOLBAR_FORM:
		strMessage = "ID_TOOLBAR_FORM button clicked.";
		break;
	case ID_TOOLBAR_LINKTOOL:
		strMessage = "ID_TOOLBAR_LINKTOOL button clicked.";
		break;
	case ID_TOOLBAR_COMMENT_TEXT:
		strMessage = "ID_TOOLBAR_COMMENT_TEXT button clicked.";
		break;
	case ID_TOOLBAR_COMMENT_NOTE:
		strMessage = "ID_TOOLBAR_COMMENT_NOTE button clicked.";
		break;
	case ID_TOOLBAR_COMMENT_STAMP:
		strMessage = "ID_TOOLBAR_COMMENT_STAMP button clicked.";
		break;
	case ID_TOOLBAR_COMMENT_PENCIL:
		strMessage = "ID_TOOLBAR_COMMENT_PENCIL button clicked.";
		break;
	case ID_TOOLBAR_COMMENT_LINE:
		strMessage = "ID_TOOLBAR_COMMENT_LINE button clicked.";
		break;
	case ID_TOOLBAR_COMMENT_RECTANGLE:
		strMessage = "ID_TOOLBAR_COMMENT_RECTANGLE button clicked.";
		break;
	case ID_TOOLBAR_COMMENT_ELLIPSE:
		strMessage = "ID_TOOLBAR_COMMENT_ELLIPSE button clicked.";
		break;
	case ID_TOOLBAR_CONTENT_TEXT:
		strMessage = "ID_TOOLBAR_CONTENT_TEXT button clicked.";
		break;
	case ID_TOOLBAR_CONTENT_LINE:
		strMessage = "ID_TOOLBAR_CONTENT_LINE button clicked.";
		break;
	case ID_TOOLBAR_CONTENT_RECTANGLE:
		strMessage = "ID_TOOLBAR_CONTENT_RECTANGLE button clicked.";
		break;
	case ID_TOOLBAR_CONTENT_ELLIPSE:
		strMessage = "ID_TOOLBAR_CONTENT_ELLIPSE button clicked.";
		break;
	case ID_TOOLBAR_CONTENT_POLYLINE:
		strMessage = "ID_TOOLBAR_CONTENT_POLYLINE button clicked.";
		break;
	case ID_TOOLBAR_SELECT_TEXT:
		strMessage = "ID_TOOLBAR_SELECT_TEXT button clicked.";
		break;
	case ID_TOOLBAR_SELECT_IMAGE:
		strMessage = "ID_TOOLBAR_SELECT_IMAGE button clicked.";
		break;
	}
	AfxMessageBox(strMessage);
}
LRESULT GlobalMessageCallback(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam, long lUserData)
{
	CTestpdfocxDlg *pOCXDlg = (CTestpdfocxDlg*)lUserData;
	switch(message)
	{
	case WM_RBUTTONDOWN:
	case WM_RBUTTONUP:
	case WM_LBUTTONDOWN:
	case WM_LBUTTONUP:
	case WM_MOUSEMOVE:
		break;
	case WM_ADD_COMMENT_FINISHED:
		pOCXDlg->ShowPopupMenu();
		break;
	case WM_SELECT_A_COMMENT:
		pOCXDlg->ShowCommentInfo();
		break;
	case WM_SELECT_A_TEXTAREA:
		{
			LPSSELECTEDTEXTCONTENT lpSelectedText = (LPSSELECTEDTEXTCONTENT)lParam;
			pOCXDlg->ShowPopupMenu();
			CString strMessage;
			strMessage.Format("Selected Rectangle=%d,%d,%d,%d\n",lpSelectedText->rect.left,lpSelectedText->rect.top,
				lpSelectedText->rect.right,lpSelectedText->rect.bottom);
			strMessage += lpSelectedText->text;
			AfxMessageBox(strMessage);
			return TRUE;
		}
	case WM_ADD_COMMENT_GET_PREDEFINED_TEXT:
		{
			pOCXDlg->strTempText = "This is a prefilled text annotation, you may predefine it easily.";
			LPSTEXTDATA lpTextData = (LPSTEXTDATA)lParam;
			if(lpTextData)
			{
				lpTextData->len = pOCXDlg->strTempText.GetLength();
				lpTextData->text = LPCTSTR(pOCXDlg->strTempText);
			}
			break;
		}
	case WM_ADD_COMMENT_CLICK:
		{
			ShowClickedButton(wParam);
			break;
		}
	}
	return FALSE; //Return FALSE if you wish call original process
}

BOOL CTestpdfocxDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	CenterWindow();
	CRect clientRect;
	GetClientRect(&clientRect);
	clientRect.top = TOP_MARGIN;
	if(!m_ctrlPDFOcx.Create(NULL,WS_CHILD|WS_VISIBLE,clientRect,this,ID_PDFOCXWND))
	{
		AfxMessageBox("Please register pdfocx.ocx file first.");
		return -1;
	}
	//m_ctrlPDFOcx.AboutBox();
	//Remove "Trial PDF View OCX" watermark by your Order ID
	m_ctrlPDFOcx.SetOrderID("XXXXXXXXXX",NULL,NULL);

	//Delete buttons from toolbar, please refer to "toolbars.pdf" document
	//to get Index ID for each button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(26); //Delete Capture Screen button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(25); //Delete Text Selection button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(24); //Separator
//	m_ctrlPDFOcx.MainToolbarDeleteButton(23); //Delete Content->Polygon
//	m_ctrlPDFOcx.MainToolbarDeleteButton(22); //Delete Content->Ellipse
//	m_ctrlPDFOcx.MainToolbarDeleteButton(21); //Delete Content->Rectangle
//	m_ctrlPDFOcx.MainToolbarDeleteButton(20); //Delete Content->Line
//	m_ctrlPDFOcx.MainToolbarDeleteButton(19); //Delete Content->Text Box
//	m_ctrlPDFOcx.MainToolbarDeleteButton(18); //Separator
//	m_ctrlPDFOcx.MainToolbarDeleteButton(17); //Delete Comment->Ellipse
//	m_ctrlPDFOcx.MainToolbarDeleteButton(16); //Delete Comment->Rectangle
//	m_ctrlPDFOcx.MainToolbarDeleteButton(15); //Delete Comment->Line
//	m_ctrlPDFOcx.MainToolbarDeleteButton(14); //Delete Comment->Pen Drawing
//	m_ctrlPDFOcx.MainToolbarDeleteButton(13); //Delete Comment->Image Stamper
//	m_ctrlPDFOcx.MainToolbarDeleteButton(12); //Delete Comment->Note
//	m_ctrlPDFOcx.MainToolbarDeleteButton(11); //Delete Comment->Text Box
//	m_ctrlPDFOcx.MainToolbarDeleteButton(10); //Separator
//	m_ctrlPDFOcx.MainToolbarDeleteButton(9);  //Delete "Link Editor" button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(8);  //Delete "Form Filling" button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(7);  //Delete "Edit Content" button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(6);  //Delete "Edit Comment" button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(5);  //Delete "View Mode" button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(4);  //Separator
//	m_ctrlPDFOcx.MainToolbarDeleteButton(3);  //Delete "Email" button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(2);  //Delete "Print" button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(1);  //Delete "Save" button
//	m_ctrlPDFOcx.MainToolbarDeleteButton(0);  //Delete "Open" button

//	if(0)
//	{//View Mode
//		//Hide the form filling button
//		m_ctrlPDFOcx.MainToolbarHideButton(32877,TRUE);
//		//Use Embed Fonts to render the comments and annotations
//		m_ctrlPDFOcx.InvokeMethod(210,1,0);
//	}
//	else
//	{//View + Form Filling Mode
//		//Show the form filling button
//		m_ctrlPDFOcx.MainToolbarHideButton(32877,FALSE);
//		//Use System Fonts to render the comments and annotations
//		m_ctrlPDFOcx.InvokeMethod(210,0,0);
//	}
	//m_ctrlPDFOcx.SetMessageCallback((long)m_hWnd,WM_MESSAGECALLBACK,(long)this);
	m_ctrlPDFOcx.SetMessageCallbackFunc((long*)&GlobalMessageCallback, (long)this);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTestpdfocxDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTestpdfocxDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTestpdfocxDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTestpdfocxDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

	if(IsWindow(m_ctrlPDFOcx.GetSafeHwnd()))
	{
		CRect m_rectClient;
		GetClientRect(&m_rectClient);
		m_rectClient.top += TOP_MARGIN;
		m_ctrlPDFOcx.MoveWindow(m_rectClient);
	}
}

BOOL CTestpdfocxDlg::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW,
		0,(HBRUSH)::GetStockObject(WHITE_BRUSH),0);	
	return CDialog::PreCreateWindow(cs);
}
void CTestpdfocxDlg::ShowPopupMenu()
{
#define MENU_ID  1000
	CMenu menuPopup;
	menuPopup.CreatePopupMenu();
	menuPopup.AppendMenu(MF_STRING,MENU_ID+0,"Menu Item0");
	menuPopup.AppendMenu(MF_STRING,MENU_ID+1,"Menu Item1");
	menuPopup.AppendMenu(MF_STRING,MENU_ID+2,"Menu Item2");
	menuPopup.AppendMenu(MF_STRING,MENU_ID+3,"Menu Item3");
	menuPopup.AppendMenu(MF_STRING,MENU_ID+4,"Menu Item4");
	menuPopup.AppendMenu(MF_STRING,MENU_ID+5,"Menu Item5");
	POINT point;
	GetCursorPos(&point);
	UINT nIndex = menuPopup.TrackPopupMenu(TPM_RETURNCMD|TPM_LEFTALIGN|TPM_LEFTBUTTON,point.x+1,point.y+1,this);
	switch(nIndex)
	{
	case MENU_ID+0:
		break;
	case MENU_ID+1:
		break;
	case MENU_ID+2:
		break;
	case MENU_ID+3:
		break;
	case MENU_ID+4:
		break;
	case MENU_ID+5:
		break;
	default:
		TRACE("Select nothing...\n");
		return;
	}
	char szBuffer[1024];
	sprintf(szBuffer,"Selected 'Menu Item%d'",nIndex-MENU_ID);
	MessageBox(szBuffer);
}
void CTestpdfocxDlg::ShowCommentInfo()
{
	int iCommentCount = m_ctrlPDFOcx.InvokeMethod(220,0,0);
	int iSelectedCommentCount = m_ctrlPDFOcx.InvokeMethod(221,0,0);
	int iSelectedComment = m_ctrlPDFOcx.InvokeMethod(222,0,0);
	
	CRect rectSelectedComment(0,0,0,0);
	m_ctrlPDFOcx.InvokeMethod(223,iSelectedComment,(long*)&rectSelectedComment);
	int iSelectedCommentType = m_ctrlPDFOcx.InvokeMethod(224,iSelectedComment,0);
	long iSelectedCommentUserData = m_ctrlPDFOcx.InvokeMethod(225,iSelectedComment,0);
	BOOL bOK = m_ctrlPDFOcx.InvokeMethod(226,iSelectedComment,(long*)this);

	TRACE("CommentCount=%d,SelectedCommentCount=%d,SelectedComment=%d,rectSelectedComment(%d,%d,%d,%d)\n",
		iCommentCount,iSelectedCommentCount,iSelectedComment,
		rectSelectedComment.left,rectSelectedComment.top,rectSelectedComment.right,rectSelectedComment.bottom);
	TRACE("SelectedCommentType=%d,SelectedCommentUserData=0x%x\n",iSelectedCommentType,iSelectedCommentUserData);
}
typedef struct TEXTINFOtag{
	RECT rect;
	char text[10];
}TEXTINFO,*LPTEXTINFO;
void CTestpdfocxDlg::OnButtonGettext() 
{
	// TODO: Add your control notification handler code here
	int iCount = m_ctrlPDFOcx.GetPageCount();
	long nTextContent = 0;
	int iCharCount = m_ctrlPDFOcx.GetTextContent(1,&nTextContent);
	LPTEXTINFO lpText = (LPTEXTINFO)nTextContent;
	for(int i = 0; i < iCharCount; i++,lpText++)
	{
		TRACE("Rect(%d,%d,%d,%d), %s\n",lpText->rect.left,lpText->rect.top,
			lpText->rect.right,lpText->rect.bottom,lpText->text);
	}
}
LRESULT CTestpdfocxDlg::OnMessageCallback(WPARAM wCallbackMessage, LPARAM lUserData)
{
	MSG *lpMsg = (MSG*)wCallbackMessage;
	return GlobalMessageCallback(lpMsg->hwnd,lpMsg->message,lpMsg->wParam,lpMsg->lParam,lUserData);
}

void CTestpdfocxDlg::OnButtonHidebuttons() 
{
	// TODO: Add your control notification handler code here
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_SAVE,TRUE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_EMAIL,TRUE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT,TRUE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_TEXT,TRUE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_LINE,TRUE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_RECTANGLE,TRUE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_ELLIPSE,TRUE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_POLYLINE,TRUE);
}

void CTestpdfocxDlg::OnButtonShowbuttons() 
{
	// TODO: Add your control notification handler code here
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_SAVE,FALSE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_EMAIL,FALSE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT,FALSE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_TEXT,FALSE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_LINE,FALSE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_RECTANGLE,FALSE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_ELLIPSE,FALSE);
	m_ctrlPDFOcx.MainToolbarHideButton(ID_TOOLBAR_CONTENT_POLYLINE,FALSE);	
}

void CTestpdfocxDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
}

BOOL CTestpdfocxDlg::IsPDFModified()
{
	long nModify = 0;
	m_ctrlPDFOcx.InvokeMethod(71,0,&nModify);
	return nModify;
}

void CTestpdfocxDlg::OnClose() 
{
	if(IsPDFModified())
	{
		MessageBox("Your PDF file has been modified.","PDF OCX",MB_ICONINFORMATION);
	}	
	CDialog::OnClose();
}

void CTestpdfocxDlg::OnButtonPdf2image() 
{
	static char BASED_CODE szFilter[] 
		="PDF File(*.pdf)|*.pdf||";
	CFileDialog  fOpenDlg(TRUE,"","",
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		szFilter,NULL);
	if(fOpenDlg.DoModal() != IDOK)
		return;
	CString strPDFFileName = fOpenDlg.GetPathName();

	char sImageFilter[] = 
		"EMF File (*.emf)|*.emf|"
		"BMP file (*.bmp)|*.bmp|"
		"WMF File (*.wmf)|*.wmf|"
		"JPG File (*.jpg;*.jpeg)|*.jpg;*.jpeg|"
		"GIF File (*.gif)|*.gif|"
		"TIF File (*.tif;*.tiff)|*.tif;*.tiff|"
		"PNG File (*.png)|*.png|"
		"TGA File (*.tga)|*.tga|"
		"PCX File (*.pcx)|*.pcx|"
		"All File (*.*)|*.*||";
	CFileDialog  fSaveDlg(TRUE,".jpg","",
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		sImageFilter,NULL);
	if(fSaveDlg.DoModal() != IDOK)
		return;
	CString strImgFileName = fSaveDlg.GetPathName();

	int iRet = m_ctrlPDFOcx.ConvertPDFToImage(strPDFFileName, strImgFileName,72,72,
		COMPRESSION_CCITTFAX4, 0, -1, -1, 24, 0);
	ShellExecuteA(m_hWnd,"open",strImgFileName,NULL,NULL,SW_SHOW);
}

void CTestpdfocxDlg::OnButtonSelectIcon() 
{
	static iSelect = 1;
	if(iSelect == 0)
		m_ctrlPDFOcx.InvokeMethod(41, 1, 0);//Hand
	else if(iSelect == 1)
		m_ctrlPDFOcx.InvokeMethod(21, 0, 0);//Text Copy
	else if(iSelect == 2)
		m_ctrlPDFOcx.InvokeMethod(22, 0, 0);//Picture Copy
	else if(iSelect == 3)
		m_ctrlPDFOcx.InvokeMethod(42, 1, 0);//Edit Comment
	else if(iSelect == 4)
		m_ctrlPDFOcx.InvokeMethod(43, 1, 0);//Edit Content
	else if(iSelect == 5)
		m_ctrlPDFOcx.InvokeMethod(45, 0, 0);//Form Filling
	else if(iSelect == 6)
		m_ctrlPDFOcx.InvokeMethod(46, 0, 0);//Edit Hyperlink
	iSelect++;
	if(iSelect >= 7)
		iSelect = 0;
	//m_ctrlPDFOcx.InvokeMethod(227, 0, 0);//Disable main popup menu
}

void CTestpdfocxDlg::OnButtonClosepdf() 
{
	// TODO: Add your control notification handler code here
	m_ctrlPDFOcx.ClosePDFFile();	
}

void CTestpdfocxDlg::OnButtonIsmodified() 
{
	if(IsPDFModified())
		MessageBox("Your PDF file has been modified.","PDF OCX",MB_ICONINFORMATION);
	else
		MessageBox("Your PDF file hasn't been modified.","PDF OCX",MB_ICONINFORMATION);
}
