﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApplication
{
    public partial class Form1 : Form
    {
        int nViewMode = 0;
        public Form1()
        {
            InitializeComponent();
        }

        private void Open_Click(object sender, EventArgs e)
        {
            OpenFileDialog dlgOpen = new OpenFileDialog();
            if (dlgOpen.ShowDialog() == DialogResult.OK)
            {
                axPdfview1.OpenPDF(dlgOpen.FileName, "", "");
            }
        }

        private void NextPage_Click(object sender, EventArgs e)
        {
            axPdfview1.ViewNextPage();
        }

        private void ActualSize_Click(object sender, EventArgs e)
        {
            axPdfview1.ZoomActualPage();
        }

        private void PreviousPage_Click(object sender, EventArgs e)
        {
            axPdfview1.ViewPreviousPage();
        }

        private void FitPage_Click(object sender, EventArgs e)
        {
            axPdfview1.ZoomFitPage();
        }

        private void FitWidth_Click(object sender, EventArgs e)
        {
            axPdfview1.ZoomFitWidth();
        }

        private void ZoomIn_Click(object sender, EventArgs e)
        {
            axPdfview1.ZoomIn();
        }

        private void ZoomOut_Click(object sender, EventArgs e)
        {
            axPdfview1.ZoomOut();
        }

        private void ViewMode_Click(object sender, EventArgs e)
        {
            if (nViewMode == 0)
                axPdfview1.ViewModeSinglePage();
            else if (nViewMode == 1)
                axPdfview1.ViewModeFacing();
            else if (nViewMode == 2)
                axPdfview1.ViewModeContinuous();
            else if (nViewMode == 3)
                axPdfview1.ViewModeContinuousFacing();
            nViewMode++;
            if (nViewMode >= 4)
                nViewMode = 0;
        }

        private void RotateLeft_Click(object sender, EventArgs e)
        {
            axPdfview1.RotateViewLeft();
        }

        private void RotateRight_Click(object sender, EventArgs e)
        {
            axPdfview1.RotateViewRight();
        }

        private void Search_Click(object sender, EventArgs e)
        {
            axPdfview1.SetFindText(SearchString.Text);
            axPdfview1.FindNextText();
        }

        private void SearchNext_Click(object sender, EventArgs e)
        {
            axPdfview1.FindNextText();
        }
    }
}
