// pdfviewerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "pdfviewer.h"
#include "pdfviewerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPdfviewerDlg dialog

CPdfviewerDlg::CPdfviewerDlg(CWnd* pParent /*=NULL*/)
	: cdxCSizingDialog(CPdfviewerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPdfviewerDlg)
	m_strText = _T("");
	m_nGotoPage = 1;
	m_fZoom = 100.0f;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	nViewMode = 0;
}

void CPdfviewerDlg::DoDataExchange(CDataExchange* pDX)
{
	cdxCSizingDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPdfviewerDlg)
	DDX_Control(pDX, IDC_LIST_INFO, m_ctrlInfo);
	DDX_Control(pDX, IDC_PDFVIEWCTRL1, m_wndPDFViewer);
	DDX_Text(pDX, IDC_EDIT_SEARCHSTRING, m_strText);
	DDX_Text(pDX, IDC_EDIT_GOTOPAGE, m_nGotoPage);
	DDX_Text(pDX, IDC_EDIT_ZOOM, m_fZoom);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPdfviewerDlg, cdxCSizingDialog)
	//{{AFX_MSG_MAP(CPdfviewerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_OPEN, OnButtonOpen)
	ON_BN_CLICKED(IDC_BUTTON_ACTUALSIZE, OnButtonActualsize)
	ON_BN_CLICKED(IDC_BUTTON_NEXTPAGE, OnButtonNextpage)
	ON_BN_CLICKED(IDC_BUTTON_PREVIOUSPAGE, OnButtonPreviouspage)
	ON_BN_CLICKED(IDC_BUTTON_FITPAGE, OnButtonFitpage)
	ON_BN_CLICKED(IDC_BUTTON_FITWIDTH, OnButtonFitwidth)
	ON_BN_CLICKED(IDC_BUTTON_VIEW_MODE, OnButtonViewMode)
	ON_BN_CLICKED(IDC_BUTTON_ROTATELEFT, OnButtonRotateleft)
	ON_BN_CLICKED(IDC_BUTTON_ROTATERIGHT, OnButtonRotateright)
	ON_BN_CLICKED(IDC_BUTTON_SEARCH, OnButtonSearch)
	ON_BN_CLICKED(IDC_BUTTON_SEARCH_NEXT, OnButtonSearchNext)
	ON_BN_CLICKED(IDC_BUTTON_SEARCH_PREVIOUS, OnButtonSearchPrevious)
	ON_BN_CLICKED(IDC_BUTTON_ZOOMIN, OnButtonZoomin)
	ON_BN_CLICKED(IDC_BUTTON_ZOOMOUT, OnButtonZoomout)
	ON_BN_CLICKED(IDC_BUTTON_GOTOPAGE, OnButtonGotopage)
	ON_BN_CLICKED(IDC_BUTTON_GETPAGEINFO, OnButtonGetpageinfo)
	ON_BN_CLICKED(IDC_BUTTON_ZOOM, OnButtonZoom)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MOUSEMOVE()
	ON_WM_MOUSEWHEEL()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDBLCLK()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_CHAR()
	ON_WM_COPYDATA()
	ON_WM_SIZE()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_BUTTON_SCROOLBAR, OnButtonScroolbar)
	ON_BN_CLICKED(IDC_BUTTON_ContextMenu, OnBUTTONContextMenu)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPdfviewerDlg message handlers

BOOL CPdfviewerDlg::OnInitDialog()
{
	cdxCSizingDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	AddSzControl(*GetDlgItem(IDC_BUTTON_OPEN),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_NEXTPAGE),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_PREVIOUSPAGE),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_EDIT_GOTOPAGE),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_GOTOPAGE),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_GETPAGEINFO),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_ACTUALSIZE),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_FITPAGE),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_FITWIDTH),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_ZOOMIN),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_ZOOMOUT),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_EDIT_ZOOM),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_ZOOM),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_VIEW_MODE),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_ROTATELEFT),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_ROTATERIGHT),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_STATIC_SEARCH),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_EDIT_SEARCHSTRING),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_SEARCH),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_SEARCH_NEXT),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_SEARCH_PREVIOUS),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_BUTTON_SCROOLBAR),mdRepos,mdNone);
	AddSzControl(*GetDlgItem(IDC_LIST_INFO),mdResize,mdRepos);
	AddSzControl(*GetDlgItem(IDC_PDFVIEWCTRL1),mdResize,mdResize);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPdfviewerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		cdxCSizingDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPdfviewerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		cdxCSizingDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPdfviewerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPdfviewerDlg::OnButtonOpen() 
{
	char szFilter[] ="PDF File (*.pdf)|*.pdf||";
	CFileDialog  fSaveDlg(TRUE,"","",
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		szFilter,this);
	if(fSaveDlg.DoModal() != IDOK)
		return;
	CString strFileName = fSaveDlg.GetPathName();
	m_wndPDFViewer.SetRegCode("XXXXXXXXXXXXXXXXXXXX");
	m_wndPDFViewer.OpenPDF(strFileName, "", "");
	m_wndPDFViewer.SetMsgCallbackWnd((long)m_hWnd);
	m_wndPDFViewer.EnableLaunchLink(0);

	m_wndPDFViewer.EnableMouseWhellInFacingMode(1);
}

void CPdfviewerDlg::OnButtonActualsize() 
{
	m_wndPDFViewer.ZoomActualPage();
}

void CPdfviewerDlg::OnButtonNextpage() 
{
	m_wndPDFViewer.ViewNextPage();	
}

void CPdfviewerDlg::OnButtonPreviouspage() 
{
	m_wndPDFViewer.ViewPreviousPage();
}

void CPdfviewerDlg::OnButtonFitpage() 
{
	m_wndPDFViewer.ZoomFitPage();	
}

void CPdfviewerDlg::OnButtonFitwidth() 
{
	// TODO: Add your control notification handler code here
	m_wndPDFViewer.ZoomFitWidth();	
}

void CPdfviewerDlg::OnButtonViewMode() 
{
	if(0)
	{
		if(nViewMode == 0)
			m_wndPDFViewer.ViewModeSinglePage();
		else if(nViewMode == 1)
			m_wndPDFViewer.ViewModeFacing();
		else if(nViewMode == 2)
			m_wndPDFViewer.ViewModeContinuous();
		else if(nViewMode == 3)
			m_wndPDFViewer.ViewModeContinuousFacing();
	}
	else
	{
		m_wndPDFViewer.SetViewMode(nViewMode);
	}
	nViewMode++;
	if(nViewMode >= 6)
		nViewMode = 0;
}

void CPdfviewerDlg::OnButtonRotateleft() 
{
	m_wndPDFViewer.RotateViewLeft();	
}

void CPdfviewerDlg::OnButtonRotateright() 
{
	m_wndPDFViewer.RotateViewRight();	
}

void CPdfviewerDlg::OnButtonSearch() 
{
	UpdateData();
	if(m_strText.GetLength() == 0)
		return;
	m_wndPDFViewer.SetFindText(m_strText);	
	m_wndPDFViewer.FindNextText();	
}

void CPdfviewerDlg::OnButtonSearchNext() 
{
	m_wndPDFViewer.FindNextText();
}

void CPdfviewerDlg::OnButtonSearchPrevious() 
{
	m_wndPDFViewer.FindPreviousText();	
}

void CPdfviewerDlg::OnButtonZoomin() 
{
	// TODO: Add your control notification handler code here
	m_wndPDFViewer.ZoomIn();
}

void CPdfviewerDlg::OnButtonZoomout() 
{
	// TODO: Add your control notification handler code here
	m_wndPDFViewer.ZoomOut();
}

void CPdfviewerDlg::OnButtonGotopage() 
{
	UpdateData();
	m_wndPDFViewer.ViewGotoPage(m_nGotoPage);
}

void CPdfviewerDlg::OnButtonGetpageinfo() 
{
	int nCurPage = m_wndPDFViewer.GetCurrentPage();
	int nPageCount = m_wndPDFViewer.GetPageTotalCount();
	float nZoom = m_wndPDFViewer.GetCurrentZoom();
	CString strMsg;
	strMsg.Format("%d of %d, zoom = %f", nCurPage, nPageCount, nZoom);
	AfxMessageBox(strMsg);	
}

void CPdfviewerDlg::OnButtonZoom() 
{
	UpdateData();
	if(m_fZoom > 0)
		m_wndPDFViewer.Zoom(m_fZoom);
}
void CPdfviewerDlg::InsertString(CString strMsg)
{
	m_ctrlInfo.InsertString(-1, strMsg);
	int nCount = m_ctrlInfo.GetCount();
	if (nCount > 0)
		m_ctrlInfo.SetCurSel(nCount-1);
}

void CPdfviewerDlg::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CString strMsg;
	strMsg.Format("OnLButtonDblClk, nFlags = 0x%x, point = (%d, %d)", nFlags, point.x, point.y);
	InsertString(strMsg);
	cdxCSizingDialog::OnLButtonDblClk(nFlags, point);
}

void CPdfviewerDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	CString strMsg;
	strMsg.Format("OnMouseMove, nFlags = 0x%x, point = (%d, %d)", nFlags, point.x, point.y);
	InsertString(strMsg);
	cdxCSizingDialog::OnMouseMove(nFlags, point);
}

BOOL CPdfviewerDlg::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
	CString strMsg;
	strMsg.Format("OnMouseWheel, nFlags = 0x%x, point = (%d, %d)", nFlags, pt.x, pt.y);
	InsertString(strMsg);
	return cdxCSizingDialog::OnMouseWheel(nFlags, zDelta, pt);
}

void CPdfviewerDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CString strMsg;
	strMsg.Format("OnLButtonDown, nFlags = 0x%x, point = (%d, %d)", nFlags, point.x, point.y);
	InsertString(strMsg);
	cdxCSizingDialog::OnLButtonDown(nFlags, point);
}

void CPdfviewerDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CString strMsg;
	strMsg.Format("OnLButtonUp, nFlags = 0x%x, point = (%d, %d)", nFlags, point.x, point.y);
	InsertString(strMsg);
	cdxCSizingDialog::OnLButtonUp(nFlags, point);
}

void CPdfviewerDlg::OnRButtonDblClk(UINT nFlags, CPoint point) 
{
	CString strMsg;
	strMsg.Format("OnRButtonDblClk, nFlags = 0x%x, point = (%d, %d)", nFlags, point.x, point.y);
	InsertString(strMsg);
	cdxCSizingDialog::OnRButtonDblClk(nFlags, point);
}

void CPdfviewerDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CString strMsg;
	strMsg.Format("OnRButtonDown, nFlags = 0x%x, point = (%d, %d)", nFlags, point.x, point.y);
	InsertString(strMsg);
	cdxCSizingDialog::OnRButtonDown(nFlags, point);
}

void CPdfviewerDlg::OnRButtonUp(UINT nFlags, CPoint point) 
{
	CString strMsg;
	strMsg.Format("OnRButtonUp, nFlags = 0x%x, point = (%d, %d)", nFlags, point.x, point.y);
	InsertString(strMsg);
	cdxCSizingDialog::OnRButtonUp(nFlags, point);
}

void CPdfviewerDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CString strMsg;
	strMsg.Format("OnKeyDown, nChar = %c, nRepCnt = %d, nFlags = %d", nChar, nRepCnt, nFlags);
	InsertString(strMsg);
	cdxCSizingDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CPdfviewerDlg::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CString strMsg;
	strMsg.Format("OnKeyUp, nChar = %c, nRepCnt = %d, nFlags = %d", nChar, nRepCnt, nFlags);
	InsertString(strMsg);
	cdxCSizingDialog::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CPdfviewerDlg::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CString strMsg;
	strMsg.Format("OnChar, nChar = %c, nRepCnt = %d, nFlags = %d", nChar, nRepCnt, nFlags);
	InsertString(strMsg);
	cdxCSizingDialog::OnChar(nChar, nRepCnt, nFlags);
}
BOOL CPdfviewerDlg::OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct) 
{
	// TODO: Add your message handler code here and/or call default
	if(pCopyDataStruct == NULL)
		return FALSE;
	switch(pCopyDataStruct->dwData)
	{
	case IDMSG_GET_LAUNCH_URL:
		{
			CString strURL((char*)pCopyDataStruct->lpData, pCopyDataStruct->cbData);
			InsertString(strURL);
			break;
		}
	case IDMSG_PAGE_CHANGED:
		{
			CString strCurrentPage((char*)pCopyDataStruct->lpData, pCopyDataStruct->cbData);
			SetDlgItemText(IDC_EDIT_GOTOPAGE, strCurrentPage);
			CString strMsg = "Current page is: ";
			strMsg += strCurrentPage;
			InsertString(strMsg);
			break;
		}
	}	
	return cdxCSizingDialog::OnCopyData(pWnd, pCopyDataStruct);
}

void CPdfviewerDlg::OnSize(UINT nType, int cx, int cy) 
{
	cdxCSizingDialog::OnSize(nType, cx, cy);
}

void CPdfviewerDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	HWND hWndScrollBar = (HWND)m_wndPDFViewer.GetScrollBar();
	CString strMsg;
	strMsg.Format("OnHScroll, nSBCode = %d, nPos = %d, hWndScrollBar = 0x%X", nSBCode, nPos, hWndScrollBar);
	InsertString(strMsg);	
	cdxCSizingDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CPdfviewerDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	HWND hWndScrollBar = (HWND)m_wndPDFViewer.GetScrollBar();
	CString strMsg;
	strMsg.Format("OnVScroll, nSBCode = %d, nPos = %d, hWndScrollBar = 0x%X", nSBCode, nPos, hWndScrollBar);
	InsertString(strMsg);	
	cdxCSizingDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

BOOL CPdfviewerDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message == WM_VSCROLL)
	{
//		HWND hVScroll = (HWND)pMsg->lParam;
	}
	
	return cdxCSizingDialog::PreTranslateMessage(pMsg);
}

void CPdfviewerDlg::OnButtonScroolbar() 
{
	HWND hWndScrollBar = (HWND)m_wndPDFViewer.GetScrollBar();
	if(hWndScrollBar == NULL)
		return;

#define MENU_SCROLLBAR_VERT_HIDE		100000
#define MENU_SCROLLBAR_VERT_SHOW		100001
#define MENU_SCROLLBAR_VERT_LINEDOWN	100002
#define MENU_SCROLLBAR_VERT_LINEUP		100003
#define MENU_SCROLLBAR_VERT_BOTTOM		100004
#define MENU_SCROLLBAR_VERT_TOP			100005
#define MENU_SCROLLBAR_VERT_PAGEDOWN	100006
#define MENU_SCROLLBAR_VERT_PAGEUP		100007

#define MENU_SCROLLBAR_HORZ_HIDE		100010
#define MENU_SCROLLBAR_HORZ_SHOW		100011
#define MENU_SCROLLBAR_HORZ_LINEDOWN	100012
#define MENU_SCROLLBAR_HORZ_LINEUP		100013
#define MENU_SCROLLBAR_HORZ_BOTTOM		100014
#define MENU_SCROLLBAR_HORZ_TOP			100015
#define MENU_SCROLLBAR_HORZ_PAGEDOWN	100016
#define MENU_SCROLLBAR_HORZ_PAGEUP		100017
#define MENU_SCROLLBAR_HIDE_SHOW		100018

	POINT point;
	GetCursorPos(&point);
	HMENU hMenu;
	hMenu = CreatePopupMenu();
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_VERT_HIDE,		"Vertical Scrollbar Hide");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_VERT_SHOW,		"Vertical Scrollbar Show");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_VERT_LINEDOWN,	"Vertical Scrollbar LineDown");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_VERT_LINEUP,	"Vertical Scrollbar Up");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_VERT_BOTTOM,	"Vertical Scrollbar Bottom");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_VERT_TOP,		"Vertical Scrollbar Top");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_VERT_PAGEDOWN,	"Vertical Scrollbar PageDown");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_VERT_PAGEUP,	"Vertical Scrollbar PageUp");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_HORZ_HIDE,		"Horizontal Scrollbar Hide");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_HORZ_SHOW,		"Horizontal Scrollbar Show");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_HORZ_LINEDOWN,	"Horizontal Scrollbar LineDown");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_HORZ_LINEUP,	"Horizontal Scrollbar Up");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_HORZ_BOTTOM,	"Horizontal Scrollbar Bottom");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_HORZ_TOP,		"Horizontal Scrollbar Top");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_HORZ_PAGEDOWN,	"Horizontal Scrollbar PageDown");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_HORZ_PAGEUP,	"Horizontal Scrollbar PageUp");
	AppendMenu(hMenu, MF_STRING, MENU_SCROLLBAR_HIDE_SHOW,		"Hide or Show Scrollbars");

	int nCmd = TrackPopupMenu(hMenu, TPM_RETURNCMD, point.x+5, point.y+5, 0, m_hWnd, NULL);
	switch(nCmd)
	{
	case MENU_SCROLLBAR_VERT_HIDE:
		::ShowScrollBar(hWndScrollBar, SB_VERT, FALSE);
		break;
	case MENU_SCROLLBAR_VERT_SHOW:
		::ShowScrollBar(hWndScrollBar, SB_VERT, TRUE);
		break;
	case MENU_SCROLLBAR_VERT_LINEDOWN:
		::SendMessage(hWndScrollBar, WM_VSCROLL, SB_LINEDOWN, 0);
		break;
	case MENU_SCROLLBAR_VERT_LINEUP:
		::SendMessage(hWndScrollBar, WM_VSCROLL, SB_LINEUP, 0);
		break;
	case MENU_SCROLLBAR_VERT_BOTTOM:
		::SendMessage(hWndScrollBar, WM_VSCROLL, SB_BOTTOM, 0);
		break;
	case MENU_SCROLLBAR_VERT_TOP:
		::SendMessage(hWndScrollBar, WM_VSCROLL, SB_TOP, 0);
		break;
	case MENU_SCROLLBAR_VERT_PAGEDOWN:
		::SendMessage(hWndScrollBar, WM_VSCROLL, SB_PAGEDOWN, 0);
		break;
	case MENU_SCROLLBAR_VERT_PAGEUP:
		::SendMessage(hWndScrollBar, WM_VSCROLL, SB_PAGEUP, 0);
		break;

	case MENU_SCROLLBAR_HORZ_HIDE:
		::ShowScrollBar(hWndScrollBar, SB_HORZ, FALSE);
		break;
	case MENU_SCROLLBAR_HORZ_SHOW:
		::ShowScrollBar(hWndScrollBar, SB_HORZ, TRUE);
		break;
	case MENU_SCROLLBAR_HORZ_LINEDOWN:
		::SendMessage(hWndScrollBar, WM_HSCROLL, SB_LINEDOWN, 0);
		break;
	case MENU_SCROLLBAR_HORZ_LINEUP:
		::SendMessage(hWndScrollBar, WM_HSCROLL, SB_LINEUP, 0);
		break;
	case MENU_SCROLLBAR_HORZ_BOTTOM:
		::SendMessage(hWndScrollBar, WM_HSCROLL, SB_BOTTOM, 0);
		break;
	case MENU_SCROLLBAR_HORZ_TOP:
		::SendMessage(hWndScrollBar, WM_HSCROLL, SB_TOP, 0);
		break;
	case MENU_SCROLLBAR_HORZ_PAGEDOWN:
		::SendMessage(hWndScrollBar, WM_HSCROLL, SB_PAGEDOWN, 0);
		break;
	case MENU_SCROLLBAR_HORZ_PAGEUP:
		::SendMessage(hWndScrollBar, WM_HSCROLL, SB_PAGEUP, 0);
		break;
	case MENU_SCROLLBAR_HIDE_SHOW:
		{
			BOOL bShow = m_wndPDFViewer.IsScrollBarShown();
			m_wndPDFViewer.ShowScrollBar(!bShow);
			break;
		}
	}
	DestroyMenu(hMenu);
}

void CPdfviewerDlg::OnBUTTONContextMenu() 
{
	BOOL bEnable = m_wndPDFViewer.IsContextMenuShown();
	bEnable = !bEnable;
	m_wndPDFViewer.ShowContextMenu(bEnable);
	if(bEnable)
		SetDlgItemText(IDC_BUTTON_ContextMenu, "HideContextMenu");
	else
		SetDlgItemText(IDC_BUTTON_ContextMenu, "ShowContextMenu");
}
