window.__loadRecipe = function(p) {
    p.recipeGetTitle = function(pad) {
        // no need for now
        var title = document.title;
        // Remove Slack
        if (title.endsWith(" Slack")) {
            title = title.replace(" Slack", "");
        }
        // Check badge by title
        if (title.startsWith("! * ") || title.startsWith("* ! ")) {
            title = title.substring(4)
        } else if (title.startsWith("! ") || title.startsWith("* ")) {
            title = title.substring(2)
        }
        return title
    };

    p.recipeGetPassiveBadge = function(pad) {
        var messageCount = 0
        try {
            let title = document.title
            if (title.startsWith("! ") || (title.startsWith("* "))) {
                if (!pad.padIsMain) {
                    const channelsWithUnreads = TS.model.channels_with_unreads
                    const pathSegs = document.location.pathname.split("/");
                    if (pathSegs.length > 3 && pathSegs[1] == "messages") {
                        messageCount = pathSegs.includes(pathSegs[2]) ? 1 : 0;
                    }
                } else {
                    messageCount = 1
                }
            } else {
                messageCount = 0
            }
        } catch (err) {
            messageCount = 0;
        }

        let rst = pad._messageCountCache < messageCount ? 1 : 0;
        pad._messageCountCache = messageCount
        return rst; 
    };

    p.recipeGetPrimaryIcon = function(pad) {
        return "";
    };

    p.recipeGetSecondaryIcon = function(pad) {
        try {
            return TS.teams.getTeamByDomain(pad.workspaceID).icon.image_102;
        } catch (err) {
            return "";
        }
    };

    p.recipeShouldPlaySound = function(pad, soundPath) {
        if (soundPath.includes("incoming_ring")) {
            if (pad.padIsMain) {
                pad.setPopupPad()
            }
        }
        return true
    };
}